% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disastr.api.R
\name{disastr.api}
\alias{disastr.api}
\title{Wrapper for the UN OCHA ReliefWeb Disaster Events API}
\usage{
disastr.api(
  limit = NULL,
  date.start = NULL,
  date.end = NULL,
  disaster = NULL,
  country = NULL,
  status = NULL,
  exact.match = FALSE,
  ascending = FALSE,
  other.query = NULL
)
}
\arguments{
\item{limit}{numeric. Provide the number of events you wish to retrieve. When set to NULL (default), 100 events are returned.
The ReliefWeb API does not support the retrieval of more than 1000 events at once. If you wish to retrieve more than
1000 disaster events, you need to distribute this over multiple calls (e.g., using a loop).
Note however that the ReliefWeb API has a call quota of 1000 data requests a day.}

\item{date.start}{character string. Enter the earliest date from which events should be retrieved. The date
string must be formatted as "yyyy-mm-dd". When set to NULL (default), the sample starts with the earliest possible event.}

\item{date.end}{character string. Enter the latest date up to which (and including) events should be retrieved. The date
string must be formatted as "yyyy-mm-dd". When set to NULL (default), data are retrieved up to the latest event.}

\item{disaster}{character vector. To return only specific disaster events, this argument takes a character vector of disaster
names. Examples of typical names are "earthquake", "flood", "land slide", "wild fire". See \url{https://reliefweb.int/disasters/} for
more disaster names that can be queried. Names are matched with loose OR operators, so that querying "land slide" also returns
events for "mud slide". To do exact matching, set the global \emph{exact.match} argument to TRUE. In this case, only one disaster type
and one country at a time can be queried.}

\item{country}{character vector. To return only specific countries, this argument takes a character vector of country
names. Names are matched with loose OR operators, so that querying "South Sudan" also returns events for the countries
"South Africa" and "Sudan". To do exact matching, set the global \emph{exact.match} argument to TRUE. In this case, only one country
and one disaster type at a time can be queried.}

\item{status}{character vector. To only return events with a specific status, this argument takes a character vector of status
terms. Possible terms are "alert", "current", and "past".}

\item{exact.match}{logical. This is a rudimentary AND/OR switch. If set to FALSE (default), all terms and words in country, disaster, and status
arguments will be matched with OR operators (possibly yielding many false positive queries). If set to TRUE, all terms are matched exactly,
and only one term per argument at a time can be queried. Use \emph{other.query} for more complex AND/OR operations.}

\item{ascending}{logical. If set to FALSE (default), events will be returned in decreasing order starting from the most
recent. If set to TRUE, events will be returned in ascending order starting from the oldest record.}

\item{other.query}{character vector. Allows users to add their own ReliefWeb API queries to the
GET call. See the \href{https://apidoc.rwlabs.org/}{ReliefWeb documentation} for query details. Vector elements are
assumed to be individual queries, and are automatically separated by an & sign.}
}
\value{
A data frame containing OCHA ReliefWeb disaster events.
}
\description{
The function \code{disastr.api()} gives access to the OCHA ReliefWeb API to retrieve a
user-defined sample of \href{https://reliefweb.int/disasters/}{disaster events},
enabling a seamless integration of regular data updates into
the research work flow.
}
\details{
The function \code{disastr.api()} is an R wrapper for
the United Nations Office for the Coordination of Humanitarian Affairs' \href{https://reliefweb.int/disasters/}{OCHA ReliefWeb disaster events} API.
Internally it uses \code{httr} to access the API, and \code{jsonlite} to manage the JSON content that the call returns. The JSON data
are converted into the base class \code{data.frame}. Variables are of class \code{character} by default.
Variables which only contain numbers as recognized by the regular
expression \verb{^[0-9]+$} are coerced into \code{numeric} before the \code{data.frame} object is returned. \cr \cr
}
\examples{
my.data.frame1 <- disastr.api()
head(my.data.frame1)

my.data.frame2 <- disastr.api(limit = 20,
date.start = "2020-01-31",
date.end = "2020-04-15")
head(my.data.frame2)
}
\references{
United Nations Office for the Coordination of Humanitarian Affairs. \emph{ReliefWeb Disasters}. \url{https://reliefweb.int/disasters/} \cr
}
\author{
Christoph Dworschak \cr Website: \href{https://www.chrisdworschak.com/}{\url{https://chrisdworschak.com/}}
}
