% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_mesh.R
\name{build_mesh}
\alias{build_mesh}
\title{Build mesh for disaggregaton model}
\usage{
build_mesh(shapes, mesh.args = NULL)
}
\arguments{
\item{shapes}{shapefile covering the region under investigation.}

\item{mesh.args}{list of parameters that control the mesh structure. \emph{convex}, \emph{concave} and \emph{resolution},
to control the boundary of the inner mesh, and \emph{max.edge}, \emph{cut} and \emph{offset}, to control the  mesh itself,
with the parameters having the same meaning as in the INLA functions \emph{inla.convex.hull} and \emph{inla.mesh.2d}.}
}
\value{
An inla.mesh object
}
\description{
\emph{build_mesh} function takes a SpatialPolygons object and mesh arguments to build an appropriate mesh for the spatial field.
}
\details{
The mesh is created by finding a tight boundary around the polygon data, and creating a fine mesh within the boundary 
and a coarser mesh outside. This speeds up computation time by only having a very fine mesh within the area of interest 
and having a small region outside with a coarser mesh to avoid edge effects.

Six mesh parameters can be specified as arguments: \emph{convex}, \emph{concave} and \emph{resolution},
to control the boundary of the inner mesh, and \emph{max.edge}, \emph{cut} and \emph{offset}, to control the  mesh itself,
with the names meaing the same as used by INLA functions \emph{inla.convex.hull} and \emph{inla.mesh.2d}.

Defaults are:
pars <- list(convex = -0.01, concave = -0.5, resolution = 300, max.edge = c(3.0, 8),  cut = 0.4, offset = c(1, 15)).
}
\examples{
\dontrun{
 polygons <- list()
 for(i in 1:100) {
   row <- ceiling(i/10)
   col <- ifelse(i \%\% 10 != 0, i \%\% 10, 10)
   xmin = 2*(col - 1); xmax = 2*col; ymin = 2*(row - 1); ymax = 2*row
   polygons[[i]] <- rbind(c(xmin, ymax), c(xmax,ymax), c(xmax, ymin), c(xmin,ymin))
 }

 polys <- do.call(raster::spPolygons, polygons)
 response_df <- data.frame(area_id = 1:100, response = runif(100, min = 0, max = 10))
 spdf <- sp::SpatialPolygonsDataFrame(polys, response_df)

 my_mesh <- build_mesh(spdf)
}

}
