% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in.R
\name{in_scatter}
\alias{in_scatter}
\title{Comparing the inputs of a praislm regression}
\usage{
in_scatter(object)
}
\arguments{
\item{object}{an object of class \code{"praislm"}, \code{"twoStepsBenchmark"}
or \code{"threeRuleSmooth"}.}
}
\value{
a named matrix time-serie of two columns, one for the low-frequency serie
and the other for the high-frequency-serie (eventually differencied if
\code{include.differenciation} is \code{TRUE}).
A \code{tscomparison} class is added to the object.
}
\description{
The function \code{in_scatter} returns low-frequency comparisons of the inputs from
a \link{praislm}, a \link{twoStepsBenchmark} or \link{threeRuleSmooth}.
}
\details{
The functions \code{plot} and \code{autoplot} can be used on this object to produce
graphics.
}
\examples{
benchmark <- twoStepsBenchmark(turnover,construction,include.rho = TRUE)
plot(in_scatter(benchmark))
}
\seealso{
\link{in_sample} \link{in_disaggr} \link{in_revisions}
\link{plot.tscomparison}
}
