% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modreg.control.R
\name{modreg.control}
\alias{modreg.control}
\title{Setting fitting values for \code{\link[dirttee]{modreg}}.}
\usage{
modreg.control(
  StartInterval = sqrt(3),
  nStart = 11,
  nInterim = NULL,
  maxit = 100,
  itInterim = 10,
  tol = 10^-4,
  tol_bw_plugin = 10^-3,
  maxit_bw_plugin = 10,
  maxit_penalty_plugin = 10,
  tol_penalty_plugin = 10^-3,
  tol_regopt = tol * 100,
  tol_opt = 10^-3,
  maxit_opt = 200,
  tol_opt2 = 10^-3,
  maxit_opt2 = 200
)
}
\arguments{
\item{StartInterval}{Starting values are based on an estimate for the mean and an interval around it. The interval is \eqn{+-\code{StartInterval} * \sigma}. Default is  \eqn{\sqrt{3}}.}

\item{nStart}{Number of starting values, considered in the first iteration. Default is 11.}

\item{nInterim}{Probably has little impact on speed and result. After \code{itInterim} weighted least squares iterations, the number of estimates is reduced from \code{nStart} to \code{nInterim} estimates. Default is 5.}

\item{maxit}{Maximum number of iterations for the weighted least squares algorithm. Default is 100.}

\item{itInterim}{Probably has little impact on speed and result. After \code{itInterim} weighted least squares iterations, the number of estimates is reduced from \code{nStart} to \code{nInterim} estimates. Default is 10.}

\item{tol}{Convergence criterion for the weighted least squares algorithm. Default is 10^-4.}

\item{tol_bw_plugin}{Convergence criterion for bandwidth selection in the \code{"Plugin"} method. Default is 10^-3.}

\item{maxit_bw_plugin}{Maximum number of iterations for bandwidth selection in the \code{"Plugin"} method. Default is 10.}

\item{maxit_penalty_plugin}{Maximum number of iterations for penalty selection in the \code{"Plugin"} method. Default is 10.}

\item{tol_penalty_plugin}{Convergence criterion for penalty selection in the \code{"Plugin"} method. Default is 10^-3.}

\item{tol_regopt}{Weighted least squares are recalculated for hyperparameter optimization. This is the convergence criterion within this optimization. Default is \code{tol} * 100.}

\item{tol_opt}{Convergence criterion for the first hyperparameter optimizion. Can be increased to reduce compuation time. Default is 10^-3.}

\item{maxit_opt}{Maximum number of iterations for the first hyperparameter optimizion. Can be lowered to reduce compuation time. Default is 200.}

\item{tol_opt2}{Convergence criterion for the second hyperparameter optimizion. Default is 10^-3.}

\item{maxit_opt2}{Maximum number of iterations for the second hyperparameter optimizion. Default is 200.}
}
\value{
A list with the arguments as components
}
\description{
This is an internal function of package \code{dirttee} which allows control of the numerical options 
for fitting mode regression. Typically, users will want to modify the defaults if model fitting 
is slow or fails to converge.
}
\details{
The algorithm is described in Seipp et al. (2022). To increase the speed of the algorithm, adapting \code{tol} and \code{maxit_opt}/\code{maxit_opt2} and other penalty / hyperparameter optimization parameters are a good starting point.
}
\references{
Seipp, A., Uslar, V., Weyhe, D., Timmer, A., & Otto-Sobotka, F. (2022). Flexible Semiparametric Mode Regression for Time-to-Event Data. Manuscript submitted for publication. \cr
Yao, W., & Li, L. (2014). A new regression model: modal linear regression. Scandinavian Journal of Statistics, 41(3), 656-671.
}
