% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{eval_dirty}
\alias{eval_dirty}
\title{Evaluate expressions}
\usage{
eval_dirty(expr, env = parent.frame(), data = NULL, quoted = TRUE)
}
\arguments{
\item{expr}{R expression or 'rlang' quo}

\item{env}{environment to evaluate}

\item{data}{dataframe or list}

\item{quoted}{Is the expression quoted? By default, this is \code{TRUE}.
This is useful when you don't want to use an expression that is stored in a
variable; see examples}
}
\value{
the executed results of \code{expr} evaluated with side effects.
}
\description{
Evaluate expressions
}
\details{
\code{eval_dirty} uses \code{base::eval()} function to evaluate
expressions. Compare to \code{rlang::eval_tidy}, which won't affect original
environment, \code{eval_dirty} causes changes to the environment. Therefore
if \code{expr} contains assignment, environment will be changed in this case.
}
\examples{

env = new.env(); env$a = 1
rlang::eval_tidy(quote({a <- 111}), env = env)
print(env$a)  # Will be 1. This is because eval_tidy has no side effect

eval_dirty(quote({a <- 111}), env)
print(env$a)  # 111, a is changed

# Unquoted case
eval_dirty({a <- 222}, env, quoted = FALSE)
print(env$a)

}
