% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\name{forelse}
\alias{forelse}
\title{Python-style \code{"for-else"} function}
\usage{
forelse(x, FUN, ALT_FUN = NULL)
}
\arguments{
\item{x}{iterative R objects such as list, vector, etc.}

\item{FUN}{function that applies to each \code{x}}

\item{ALT_FUN}{function that takes no argument or other types of R
object}
}
\value{
If any \code{FUN} returns anything other than \code{NULL},
then the function returns the first none \code{NULL} object. If
all \code{x} fed to \code{FUN} return \code{NULL}, then this
function returns \code{ALT_FUN} (if \code{ALT_FUN} is not a function)
or the result of \code{ALT_FUN()}.
}
\description{
Provide Python-style \code{"for-else"} that works as
follows: for each element, execute "for" block, if there is break
while executing "for" block, then just stop and ignore the "else"
statement, otherwise run "else" block.
}
\examples{

# --------------------------- Basic Usage ------------------------------

# 1. ALT_FUN get executed because FUN returns NULL for all items in x
forelse(
  1:10,
  function(x){
    cat('The input is ', x, end = '\n')
    if( x > 10) return(x) else return(NULL)
  },
  function(){
    cat('ALT_FUN is executed!\n')
    'wow'
  }
)

# 2. FUN returns non-NULL object
forelse(
  1:10,
  function(x){
    cat('The input is ', x, end = '\n')
    if( x \%\% 2 == 0 ) return(x) else return(NULL)
  },
  'wow'
)

# --------------------------- Performance ------------------------------
FUN <- function(x){
  Sys.sleep(0.01)
  if( x \%\% 2 == 0 ) return(x) else return(NULL)
}

microbenchmark::microbenchmark({
  forelse(1:10, FUN, 'wow')
}, {
  y <- unlist(lapply(1:10, FUN))
  if(length(y)){
    y <- y[[1]]
  }else{
    y <- 'wow'
  }
}, {
  y <- NULL
  for(x in 1:10){ y <- FUN(x) }
  if(is.null(y)){ y <- 'wow' }
}, times = 3)


}
