% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_date_xx}
\alias{format_date_xx}
\alias{format.date_y}
\alias{format.date_yq}
\alias{format.date_ym}
\alias{format.date_yw}
\alias{format_yq_iso}
\alias{format_yq_short}
\alias{format_yq_shorter}
\alias{format_ym_iso}
\alias{format_ym_short}
\alias{format_ym_shorter}
\alias{format_yw_iso}
\alias{format_yw_short}
\alias{format_yw_shorter}
\title{Format a date_xx}
\usage{
\method{format}{date_y}(x, format = "\%Y", ...)

\method{format}{date_yq}(
  x,
  format = "\%Y-Q\%q",
  month_names = format(ISOdate(2000, 1:12, 1), "\%B"),
  month_abb = format(ISOdate(2000, 1:12, 1), "\%b"),
  ...
)

\method{format}{date_ym}(
  x,
  format = "\%Y-M\%m",
  month_names = format(ISOdate(2000, 1:12, 1), "\%B"),
  month_abb = format(ISOdate(2000, 1:12, 1), "\%b"),
  ...
)

\method{format}{date_yw}(x, format = "\%Y-W\%V", ...)

format_yq_iso(x)

format_yq_short(x)

format_yq_shorter(x)

format_ym_iso(x)

format_ym_short(x)

format_ym_shorter(x)

format_yw_iso(x)

format_yw_short(x)

format_yw_shorter(x)
}
\arguments{
\item{x}{any \R object.}

\item{format}{A format that uses a subset of the same placeholders as
\code{\link[base:strptime]{base::strptime()}}:
\tabular{rl}{
\verb{\%Y} \tab Year with century (the full year)\cr
\verb{\%y} \tab Year without century (the last two digits of the year)\cr
\verb{\%m} \tab Month as a decimal numbers (01-12)\cr
\verb{\%B} \tab Full month name\cr
\verb{\%b} \tab Abbreviated month name\cr
\verb{\%V} \tab Week of the year as decimal number (01-53) as defined in
\href{https://en.wikipedia.org/wiki/ISO_week_date}{ISO8601}
}
Not all placeholders are supported for all \code{date_xx} subclasses.
Literal \code{"\%"} can be escaped with \code{"\%\%"} (as in \code{\link[base:sprintf]{base::sprintf()}}).}

\item{...}{ignored}

\item{month_names, month_abb}{a \code{character} vector of length 12: Names and
abbreviations for months that will be used for the
placeholders \code{"\%b"} and \code{"\%B"}. Defaults to the values for
the current locale for compatibility with \code{\link[base:strptime]{base::strptime()}}.}
}
\value{
a \code{character} vector
}
\description{
Format a date_xx
}
\section{Formatting shorthands}{


Format shorthand functions in the form of \verb{format_y*_[preset]()} directly
apply formatting presets to anything  that can be coerced to a \code{date_xx}.
This is notably handy as they can be used as a labeling function for
\strong{ggplot2}  axes (see \code{vignette("dint")})
}

\examples{
x <- date_ym(2018, c(1L, 10L, 3L, 6L, 4L, 5L, 7L, 12L, 2L, 9L, 8L, 11L))
fm <- "\%Y-M\%m: \%B,\%b"

format(
  x,
  format = fm,
  month_names = month.name,  # built-in R constant for English names
  month_abb = month.abb
)
}
