% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_date_xx.R
\name{date_xx_breaks}
\alias{date_xx_breaks}
\alias{date_yq_breaks}
\alias{date_ym_breaks}
\alias{date_yw_breaks}
\title{Pretty Breaks For date_xx Vectors}
\usage{
date_yq_breaks(n = 6)

date_ym_breaks(n = 6)

date_yw_breaks(n = 6)
}
\arguments{
\item{n}{\code{NULL} or \code{integer} scalar. The desired maximum number of breaks.
The breaks algorithm may choose less breaks if it sees fit.}
}
\value{
a \code{function} that calculates a maximum of \code{n} breaks for a \code{date_xx}
vector
}
\description{
\code{date_*_breaks} does not return breaks, but a function that calculates
breaks. This is for compatbility with the breaks functions from \pkg{scales}
such as \code{\link[scales:pretty_breaks]{scales::pretty_breaks()}}, and for ease of use with \pkg{ggplot2}.
}
\examples{
x <- date_ym(2016, 1:12)
date_ym_breaks()(x)
date_ym_breaks(12)(x)
}
