% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_ym}
\alias{format_ym}
\title{Coerce and Format to Year-Month Strings}
\usage{
format_ym(x, m = NULL, format = "\%Y-M\%m")
}
\arguments{
\item{x, m}{Two integer (vectors). \code{m} is optional and the interpretation of
\code{x} will depend on whether \code{m} is supplied or not:
\itemize{
\item if only \code{x} is supplied, \code{x} will be passed to \code{\link[=as_date_ym]{as_date_ym()}}
(e.g. \code{x = 201604} means April 2016)
\item if \code{x} and \code{m} are supplied, \code{x} is interpreted as year and \code{m} as
month.
}}

\item{format}{A format that uses a subset of the same placeholders as
\code{\link[base:strptime]{base::strptime()}}:
\tabular{rl}{
\code{\%Y} \tab Year with century (the full year)\cr
\code{\%y} \tab Year without century (the last two digits of the year)\cr
\code{\%m} \tab Month as a decimal numbers (01-12)\cr
\code{\%B} \tab Full month name\cr
\code{\%b} \tab Abbreviated month name
}
Not all placeholders are supported for all \code{date_xx} subclasses.
Literal \% can be escaped with \code{"\%\%"} (as in \code{\link[base:sprintf]{base::sprintf()}}).}
}
\value{
a \code{character} vector
}
\description{
Coerce and Format to Year-Month Strings
}
\section{Formatting shorthands}{


Format shorthand functions in the form of \code{format_y*_[preset]()} directly
apply formatting presets to anything  that can be coerced to a \code{date_xx}.
This is notably handy as they can be used as a labelling function for
\strong{ggplot2}  axes (see \code{vignette("dint")})
}

\examples{

format_ym(2015, 5)
format_ym(201505, format = "short")
format_ym(201505, format = "shorter")

}
\seealso{
\code{\link[=format.date_ym]{format.date_ym()}}

Other coerce and format functions: \code{\link{format_yq}},
  \code{\link{format_yw}}
}
\concept{coerce and format functions}
