% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mutators.R
\docType{methods}
\name{get_eigenvalues}
\alias{get_eigenvalues}
\alias{get_eigenvalues-method}
\alias{get_inertia}
\alias{get_inertia-method}
\alias{get_variance}
\alias{get_variance-method}
\alias{get_eigenvalues,MultivariateAnalysis-method}
\alias{get_inertia,MultivariateAnalysis-method}
\alias{get_variance,MultivariateAnalysis-method}
\title{Get Eigenvalues}
\usage{
get_eigenvalues(x)

get_inertia(x, ...)

get_variance(x, ...)

\S4method{get_eigenvalues}{MultivariateAnalysis}(x)

\S4method{get_inertia}{MultivariateAnalysis}(x, margin = 1)

\S4method{get_variance}{MultivariateAnalysis}(x, digits = 2)
}
\arguments{
\item{x}{An object from which to get element(s) (a \code{\linkS4class{CA}} or
\code{\linkS4class{PCA}} object).}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{digits}{An \code{\link{integer}} indicating the number of decimal places to be
used.}
}
\value{
\itemize{
\item \code{get_eigenvalues()} returns a \code{\link{data.frame}} with the following columns:
\code{eigenvalues}, \code{variance} (percentage of variance) and \code{cumulative}
(cumulative percentage of variance).
\item \code{get_variance()} returns a \code{\link{numeric}} vector giving the percentage of
explained variance of each dimension.
\item \code{get_inertia()} returns a \code{\link{numeric}} vector.
}
}
\description{
Get Eigenvalues
}
\seealso{
Other mutators: 
\code{\link{get_contributions}()},
\code{\link{get_coordinates}()},
\code{\link{get_data}()},
\code{\link{get_distances}()},
\code{\link{mutators}},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
