% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/summary.R
\docType{methods}
\name{summary}
\alias{summary}
\alias{summary,CA-method}
\alias{summary,PCA-method}
\title{Object Summaries}
\usage{
\S4method{summary}{CA}(object, margin = 1, active = TRUE, sup = TRUE, rank = 3)

\S4method{summary}{PCA}(object, margin = 1, active = TRUE, sup = TRUE, rank = 3)
}
\arguments{
\item{object}{A \code{\linkS4class{CA}} or \code{\linkS4class{PCA}} object.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be summarized: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{active}{A \code{\link{logical}} scalar: should the active observations be
summarized?}

\item{sup}{A \code{\link{logical}} scalar: should the supplementary observations be
summarized?}

\item{rank}{An \code{\link{integer}} value specifying the maximal number of components
to be kept in the results.}
}
\description{
Provides a summary of the results of a multivariate data analysis.
}
\examples{
## Load data
data("zuni", package = "folio")

## Compute correspondence analysis
X <- ca(zuni, rank = 5, sup_row = 1:50)

## Rows summary
summary(X, margin = 1)

## Columns summary
summary(X, margin = 2)
}
\author{
N. Frerebeau
}
\concept{summary}
