% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mutators.R, R/pca.R
\docType{methods}
\name{mutator}
\alias{mutator}
\alias{get}
\alias{set}
\alias{get_coordinates}
\alias{get_coordinates-method}
\alias{get_replications}
\alias{get_replications-method}
\alias{get_contributions}
\alias{get_contributions-method}
\alias{get_correlations}
\alias{get_correlations-method}
\alias{get_cos2}
\alias{get_cos2-method}
\alias{get_data}
\alias{get_data-method}
\alias{get_distances}
\alias{get_distances-method}
\alias{get_eigenvalues}
\alias{get_eigenvalues-method}
\alias{get_inertia}
\alias{get_inertia-method}
\alias{get_variance}
\alias{get_variance-method}
\alias{dim,MultivariateAnalysis-method}
\alias{rownames,MultivariateAnalysis-method}
\alias{colnames,MultivariateAnalysis-method}
\alias{dimnames,MultivariateAnalysis-method}
\alias{get_contributions,MultivariateAnalysis-method}
\alias{get_coordinates,MultivariateAnalysis-method}
\alias{get_replications,MultivariateBootstrap-method}
\alias{get_replications,BootstrapPCA-method}
\alias{get_correlations,PCA-method}
\alias{get_cos2,MultivariateAnalysis-method}
\alias{get_data,MultivariateAnalysis-method}
\alias{get_distances,MultivariateAnalysis-method}
\alias{get_eigenvalues,MultivariateAnalysis-method}
\alias{get_inertia,MultivariateAnalysis-method}
\alias{get_variance,MultivariateAnalysis-method}
\alias{loadings,PCA-method}
\title{Get Results}
\usage{
get_coordinates(x, ...)

get_replications(x, ...)

get_contributions(x, ...)

get_correlations(x, ...)

get_cos2(x, ...)

get_data(x, ...)

get_distances(x, ...)

get_eigenvalues(x)

get_inertia(x, ...)

get_variance(x, ...)

\S4method{dim}{MultivariateAnalysis}(x)

\S4method{rownames}{MultivariateAnalysis}(x)

\S4method{colnames}{MultivariateAnalysis}(x)

\S4method{dimnames}{MultivariateAnalysis}(x)

\S4method{get_contributions}{MultivariateAnalysis}(x, margin = 1)

\S4method{get_coordinates}{MultivariateAnalysis}(x, margin = 1, sup_name = ".sup")

\S4method{get_replications}{MultivariateBootstrap}(x, margin = 1)

\S4method{get_replications}{BootstrapPCA}(x)

\S4method{get_correlations}{PCA}(x, sup_name = ".sup")

\S4method{get_cos2}{MultivariateAnalysis}(x, margin = 1, sup_name = ".sup")

\S4method{get_data}{MultivariateAnalysis}(x)

\S4method{get_distances}{MultivariateAnalysis}(x, margin = 1)

\S4method{get_eigenvalues}{MultivariateAnalysis}(x)

\S4method{get_inertia}{MultivariateAnalysis}(x, margin = 1)

\S4method{get_variance}{MultivariateAnalysis}(x, digits = 2)

\S4method{loadings}{PCA}(x)
}
\arguments{
\item{x}{An object from which to get element(s) (a \code{\linkS4class{CA}} or
\code{\linkS4class{PCA}} object).}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{sup_name}{A \code{\link{character}} string specifying the name of the column to
create for supplementary points attribution (see below).}

\item{digits}{An \code{\link{integer}} indicating the number of decimal places to be
used.}
}
\value{
\verb{get_*()} returns a \code{\link{numeric}} vector or a \code{\link{data.frame}}.

\code{loadings()} returns of a \code{\link{matrix}} of class \link[stats:loadings]{stats::loadings}.
}
\description{
Getters to retrieve parts of an object.
}
\details{
\code{get_data()} returns a \code{data.frame} of original data.

\code{get_contributions()} returns a \code{data.frame} of contributions to the
definition of the principal dimensions.

\code{get_coordinates()} returns a \code{data.frame} of coordinates. An extra column
(named after \code{sup_name}) is added specifying whether an observation is a
supplementary point or not.

\code{get_replications()} returns an \code{array} of replicated coordinates
(see \code{\link[=bootstrap]{bootstrap()}}).

\code{get_correlations()} returns a \code{data.frame} of correlations between
variables and dimensions (\code{PCA}). An extra column (named after \code{sup_name})
is added specifying whether an observation is a supplementary point or not.

\code{get_cos2()} returns a \code{data.frame} of \eqn{cos^2}{cos2} values (i.e.
quality of the representation of the points on the factor map). An extra
column (named after \code{sup_name}) is added specifying whether an observation
is a supplementary point or not.

\code{get_eigenvalues()} returns a \code{data.frame} with the following columns:
\code{eigenvalues}, \code{variance} (percentage of variance) and \code{cumulative}
(cumulative percentage of variance).

\code{get_variance()} returns a \code{numeric} vector giving the percentage of
explained variance of each dimension.

\code{loadings()} returns variable loadings (i.e. the coefficients of the linear
combination of the original variables). \code{loadings()} is only implemented for
consistency with \pkg{[stats][stats::loadings]}.
}
\seealso{
Other mutator: 
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{mutator}
