C
C
C
      SUBROUTINE NPREG(Y,SCL,SY,L,U,F,RES,W,P,TAU,KNX,KNV,KNSTR,N,
     1         NKNTS,NPEAK,MULT,LCL,TRIANG,RUN,VERB,BMM,EPS,DDMAX)
      INTEGER NPEAK,N,NKNTS
      DOUBLE PRECISION Y(N),SCL(N),SY(N+1),L(N+1),U(N+1),F(N+1)
C      DOUBLE PRECISION Y(N+1),SCL(N+1),SY(N+1),L(N+1),U(N+1),F(N+1)
      DOUBLE PRECISION RES(N+1),W(N+1)
      DOUBLE PRECISION P,TAU,EPS,DDMAX
      INTEGER KNX(N+1),KNV(N+1),KNSTR(N+1)
      LOGICAL LCL,MULT,TRIANG,RUN,VERB,BMM

      DOUBLE PRECISION LN2,SQZFAC,SQZFAC0,TAU1,RMN
      LOGICAL AGAIN
      INTEGER RUNMAX,RUNFAC,IC,ICMAX,IMN,NPEAK0,NPEAK1
C
C
      IF(DDMAX.LT.-0.5D0) THEN
         CALL CHCKINTS(Y,KNV,N,W,P,TAU,MULT,BMM,AGAIN,DDMAX)

         RETURN
      ENDIF
C
      SQZFAC=0.8D0
      ICMAX=100
C
      IF(NPEAK.GE.0) THEN
         CALL INTGRTY(Y,SY,N)
         CALL SETBNDS(SY,L,U,N+1,EPS)
         IC=0
 55      CONTINUE
         IF(IC.GT.100) RETURN
         IC=IC+1
         CALL CSTRING(L,U,N+1,KNX,KNV,KNSTR,NKNTS)
         CALL CDSTRING(L,U,N+1,KNSTR,NKNTS,RES)
         CALL LCLXTRMS(RES,N,KNX,NPEAK0)
C         IF(VERB) WRITE(*,*) NPEAK,NPEAK0,IC
         IF(NPEAK0.LT.NPEAK.AND.IC.LT.ICMAX) THEN
            CALL ADJSTBDS(L,U,N+1,KNV,SQZFAC,.FALSE.)
            GOTO 55
         ENDIF
         SQZFAC0=1D0/SQZFAC
         CALL ADJSTBDS(L,U,N+1,KNV,SQZFAC0,.FALSE.)
         SQZFAC=(1D0+SQZFAC)/2D0
         IF(SQZFAC.LE.0.999D0) GOTO 55
         CALL CSTRING(L,U,N+1,KNX,KNV,KNSTR,NKNTS)
         CALL CDSTRING(L,U,N+1,KNSTR,NKNTS,F)
         CALL STRING(L,U,N+1,KNSTR,NKNTS,W)
         CALL LCLXTRMS(F,N,KNX,NPEAK)
         GOTO 60
      ENDIF
C
C
      IF(EPS.GT.0D0) THEN
         CALL INTGRTY(Y,SY,N)
         CALL SETBNDS(SY,L,U,N+1,EPS)
         CALL CSTRING(L,U,N+1,KNX,KNV,KNSTR,NKNTS)
         CALL CDSTRING(L,U,N+1,KNSTR,NKNTS,F)
         CALL STRING(L,U,N+1,KNSTR,NKNTS,W)
         CALL LCLXTRMS(F,N,KNX,NPEAK)
         RETURN
      ENDIF
C
C
      DO 5 I=1,N
         F(I)=0D0
         L(I)=0D0
         U(I)=0D0
         RES(I)=Y(I)/SCL(I)
 5    CONTINUE
         F(N+1)=0D0
         L(N+1)=0D0
         U(N+1)=0D0
C      DO 5 I=1,N+1
C         F(I)=0D0
C         L(I)=0D0
C         U(I)=0D0
C         RES(I)=Y(I)/SCL(I)
C 5    CONTINUE
C
      CALL RSDLS(Y,F,SCL,N,RES)
      CALL CHCKINTS(RES,KNV,N,W,P,TAU,MULT,BMM,AGAIN,DDMAX)
      IF(AGAIN) GOTO 6
      IF(TRIANG) THEN
         CALL CHCKTRI(RES,W,KNV,N,P,TAU,BMM,AGAIN,DDMAX)
         IF(AGAIN) GOTO 6
      ENDIF
      IF(RUN) THEN
         RUNMAX=INT(DLOG(DBLE(N))-DLOG(-DLOG(0.9D0)))/DLOG(2D0)-1
         CALL CNTRUN(RES,KNV,N,RUNMAX,AGAIN)
         IF(AGAIN) GOTO 6
      ENDIF
      RETURN
C
 6    CONTINUE
C
      CALL INTGRTY(Y,SY,N)
      CALL SETBNDS(SY,L,U,N+1,EPS)
C
      IF(TRIANG) THEN
         IC=1
 15      CONTINUE
         CALL RSDLS(Y,F,SCL,N,RES)
         CALL CHCKTRI(RES,W,KNV,N,P,TAU,BMM,AGAIN,DDMAX)
C         IF(VERB) WRITE(*,*) IC,NPEAK
         IF (AGAIN.AND.IC.LE.ICMAX) THEN
            IC=IC+1
            CALL ADJSTBDS(L,U,N+1,KNV,SQZFAC,LCL)
            CALL CSTRING(L,U,N+1,KNX,KNV,KNSTR,NKNTS)
            CALL CDSTRING(L,U,N+1,KNSTR,NKNTS,F)
            CALL LCLXTRMS(F,N,KNX,NPEAK)
            GOTO 15
         ENDIF
         CALL STRING(L,U,N+1,KNSTR,NKNTS,W)
         GOTO 60
      ENDIF
C
      IF(RUN) THEN
         IC=1
 20      CONTINUE
         CALL RSDLS(Y,F,SCL,N,RES)
         CALL CNTRUN(RES,KNV,N,RUNMAX,AGAIN)
C         IF(VERB) WRITE(*,*) IC,NPEAK
         IF (AGAIN.AND.IC.LE.ICMAX) THEN
            CALL ADJSTBDS(L,U,N+1,KNV,SQZFAC,LCL)
            CALL CSTRING(L,U,N+1,KNX,KNV,KNSTR,NKNTS)
            CALL CDSTRING(L,U,N+1,KNSTR,NKNTS,F)
            CALL LCLXTRMS(F,N,KNX,NPEAK)
            GOTO 20
         ENDIF
         CALL STRING(L,U,N+1,KNSTR,NKNTS,W)
         GOTO 60
      ENDIF

      IC=1
 10   CONTINUE
      CALL CSTRING(L,U,N+1,KNX,KNV,KNSTR,NKNTS)
      CALL CDSTRING(L,U,N+1,KNSTR,NKNTS,F)
      CALL LCLXTRMS(F,N,KNX,NPEAK)
      CALL RSDLS(Y,F,SCL,N,RES)
      IC=IC+1
      CALL CHCKINTS(RES,KNV,N,W,P,TAU,MULT,BMM,AGAIN,DDMAX)
C      IF(VERB) WRITE(*,*) IC,NPEAK
      IF (AGAIN.AND.IC.LE.ICMAX) THEN
         CALL ADJSTBDS(L,U,N+1,KNV,SQZFAC,LCL)
         GOTO 10
      ENDIF
      CALL STRING(L,U,N+1,KNSTR,NKNTS,W)
C
C
C
 60   CONTINUE
      IC=0
 70   CONTINUE
c      return
      IC=IC+1
      CALL CSTRING(L,U,N+1,KNX,KNV,KNSTR,NKNTS)
      CALL CDSTRING(L,U,N+1,KNSTR,NKNTS,RES)
      CALL LCLXTRMS(RES,N,KNX,NPEAK1)
C      IF(VERB) WRITE(*,*) NPEAK,NPEAK1,IC
      IF(NPEAK1.LE.NPEAK.AND.IC.LE.ICMAX) THEN
         CALL ADJSTBDS(L,U,N+1,KNV,SQZFAC,.FALSE.)
         GOTO 70
      ENDIF
      IF (IC.GE.4) THEN
         SQZFAC0=1D0/SQZFAC**3
      ELSE
         SQZFAC0=1D0/SQZFAC
      ENDIF
      CALL ADJSTBDS(L,U,N+1,KNV,SQZFAC0,.FALSE.)
      CALL CSTRING(L,U,N+1,KNX,KNV,KNSTR,NKNTS)
      CALL CDSTRING(L,U,N+1,KNSTR,NKNTS,F)
      CALL LCLXTRMS(F,N,KNX,NPEAK)
      CALL STRING(L,U,N+1,KNSTR,NKNTS,W)
 100  CALL  MONLSINT(SY,F,N,KNX,NPEAK,KNV)
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

C
C
C
      SUBROUTINE INTGRTY(Y,SY,N)
      DOUBLE PRECISION Y(N),SY(N+1)
C
      SY(1)=0D0
      DO 10 I=2,N+1
c         SY(I)=SY(I-1)+Y(I-1)*(X(I)-X(I-1))
         SY(I)=SY(I-1)+Y(I-1)
 10   CONTINUE
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE SETBNDS(SY,L,U,N,EPS)
      DOUBLE PRECISION SY(N),L(N),U(N)
      DOUBLE PRECISION DEV,EPS
C
      DEV=0D0
      DO 10 I=1,N
         DEV=DMAX1(DEV,DABS(SY(I)-SY(N)*DBLE(I-1)/DBLE(N)))
 10   CONTINUE
C
      DO 20 I=1,N
         IF(EPS.GT.0D0) THEN
            L(I)=SY(I)-EPS
            U(I)=SY(I)+EPS 
         ELSE
            L(I)=SY(I)-1.1D0*DEV
            U(I)=SY(I)+1.1D0*DEV 
         ENDIF
 20   CONTINUE
      U(1)=(U(1)+L(1))/2D0
      L(1)=U(1)
      U(N)=(U(N)+L(N))/2D0
      L(N)=U(N)
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     COUNTS ONLY INTERIOR PEAKS
C
      SUBROUTINE LCLXTRMS(D,N,KLOC,NPEAK)
      DOUBLE PRECISION D(N)
      INTEGER KLOC(N)
C
      NPEAK=0
      INC=0
      IDC=0
      DO 10 I=1,N-1
         IF(D(I).LT.D(I+1)) THEN
            INC=1
            J1=I+1
            IF(IDC.EQ.1) THEN
               NPEAK=NPEAK+1
               KLOC(NPEAK)=(J2+I)/2
               IDC=0
            ENDIF
         ENDIF
         IF(D(I).GT.D(I+1)) THEN
            IDC=1
            J2=I+1
            IF(INC.EQ.1) THEN
               NPEAK=NPEAK+1
               KLOC(NPEAK)=(J1+I)/2
               INC=0
            ENDIF
         ENDIF
 10   CONTINUE
      return
C
      END
C
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE RSDLS(Y,F,SCL,N,RES)
      DOUBLE PRECISION Y(N),F(N),SCL(N),RES(N)
C
      DO 10 I=1,N
         RES(I)=(Y(I)-F(I))/SCL(I)
 10   CONTINUE
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C

      SUBROUTINE CHCKINTS(RES,KNV,N,W,P,TAU,MULT,BMM,ADJUST,DDMAX)
      INTEGER N
      DOUBLE PRECISION RES(N),W(N+1)
      DOUBLE PRECISION P,TAU,DDMAX
      INTEGER KNV(N)
      LOGICAL ADJUST,MULT,BMM
C
      DOUBLE PRECISION SIGNUM
C
      ADJUST=.FALSE.
C
      W(1)=0D0
      DO 10 I=2,N+1
         KNV(I-1)=0
         W(I)=W(I-1)+RES(I-1)
c         W(I)=W(I-1)+SIGNUM(RES(I-1))

 10   CONTINUE
C
      IF(MULT) THEN
         CALL CHCKMULT(W,KNV,N,P,TAU,BMM,ADJUST,DDMAX)
      ELSE
         CALL CHCKALL(W,KNV,N,TAU,BMM,ADJUST,DDMAX)
      ENDIF
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE CHCKMULT(W,KNV,N,P,TAU,BMM,ADJUST,DDMAX)
      INTEGER N
      DOUBLE PRECISION W(N+1)
      DOUBLE PRECISION P,TAU,DDMAX   
      INTEGER KNV(N)
      LOGICAL BMM,ADJUST
C
      DOUBLE PRECISION A1,A2,A3,AK2,D,GAM,THRSH,THRSH0,THRSH1,D2
      INTEGER K,NK,JJ,IS,IMAX
C
C
      DDMAX=-1D20
      IF(.NOT.BMM) GOTO 5
      IF(P.LE.2.0D0.AND.P.GE.1.75D0) THEN
         A1=(2.75D0*(P-1.75)+3D0*(2.0D0-P))/0.25D0
         A2=(2.08D0*(P-1.75)+1.66D0*(2.0D0-P))/0.25D0
         A3=(0.31D0*(P-1.75)+0.20D0*(2.0D0-P))/0.25D0
      ELSEIF(P.LE.1.75D0.AND.P.GE.1.5D0) THEN
         A1=(3D0*(P-1.5)+3.3D0*(1.75D0-P))/0.25D0
         A2=(1.66D0*(P-1.5)+1.59D0*(1.75D0-P))/0.25D0
         A3=(0.20D0*(P-1.5)+0.19D0*(1.75D0-P))/0.25D0
      ELSEIF(P.LE.1.5D0.AND.P.GE.1.25D0) THEN
         A1=(3.3D0*(P-1.25)+3.8D0*(1.5D0-P))/0.25D0
         A2=(1.59D0*(P-1.25)+1.82D0*(1.5D0-P))/0.25D0
         A3=(0.19D0*(P-1.25)+0.21D0*(1.5D0-P))/0.25D0
      ELSEIF(P.LE.1.25D0.AND.P.GE.1.1D0) THEN
         A1=(3.8D0*(P-1.1D0)+4D0*(1.25D0-P))/0.15D0
         A2=(1.82D0*(P-1.1D0)+1.94D0*(1.25D0-P))/0.15D0
         A3=(0.21D0*(P-1.1D0)+0.236D0*(1.25D0-P))/0.15D0
      ENDIF
      GAM=A1-DEXP(A2-A3*DLOG(DBLE(N)))
      GAM=6.23D0
C
 5    CONTINUE
C
      THRSH1=DSQRT(TAU*DLOG(DBLE(N)))
      INCOLD=0
      K=1
 10   CONTINUE
      IF(P**K.GE.DBLE(N)) RETURN
      AK2=P**(K-1)
      LEN=INT(AK2)
      IF(LEN.EQ.LENOLD) THEN
         K=K+1
         GOTO 10
      ENDIF
      LENOLD=LEN
      INC=MAX0(LEN/10,1)
      I=1
 15   CONTINUE
      J=MIN0(N,I+LEN)
      D=DABS((W(J)-W(I))/DSQRT(DBLE(J-I)))
      IF(BMM) THEN
         THRSH=DSQRT(2D0*(DLOG(DBLE(N)/DBLE(J-I)))
     1        +GAM*DLOG(DLOG(1.6D1*DBLE(N)/DBLE(J-I))))
         D2=D**2-2D0*(DLOG(DBLE(N)/DBLE(J-I)))
         D2=D2/DLOG(DLOG(1.6D1*DBLE(N)/DBLE(J-I)))
         DDMAX=DMAX1(DDMAX,D2)
      ELSE
         THRSH=THRSH1
         DDMAX=DMAX1(DDMAX,D)
      ENDIF

      IF(D.GT.THRSH) THEN
         DO 20 IJ=I,J
            KNV(IJ)=1
 20      CONTINUE
         ADJUST=.TRUE.
      ENDIF
 25   CONTINUE
      I=I+INC
      IF(I.GE.N-1) THEN
         K=K+1
         GOTO 10
      ENDIF
      GOTO 15
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C

      SUBROUTINE CHCKALL(W,KNV,N,TAU,BMM,ADJUST,DDMAX)
      INTEGER N
      DOUBLE PRECISION W(N+1)
      DOUBLE PRECISION TAU,DDMAX
      INTEGER KNV(N)
      LOGICAL BMM,ADJUST
C
      DOUBLE PRECISION D,THRSH,THRSH0,THRSH1,GAM
C
      DDMAX=0D0
      IF(BMM) THEN
         GAM=6D0-EXP(1.90D0-0.117D0*DLOG(DBLE(N)))
      ENDIF
      THRSH1=DSQRT(TAU*DLOG(DBLE(N)))
C
      DO 30 I=1,N-1
         DO 20 J=I,N
            D=DABS(W(J+1)-W(I))/DSQRT(DBLE(J-I+1))
            IF(BMM) THEN
               THRSH=DSQRT(2D0*(DLOG(DBLE(N)/DBLE(J-I+1)))
     1              +GAM*DLOG(DLOG(1.6D1*DBLE(N)/DBLE(J-I+1))))
            ELSE
               THRSH=THRSH1
            ENDIF
            DDMAX=DMAX1(DDMAX,D)
            IF(D.GT.THRSH) THEN
               DO 10 K=I,J
                  KNV(K)=1
 10            CONTINUE
               ADJUST=.TRUE.
            ENDIF
 20      CONTINUE
 30   CONTINUE
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE CHCKTRI(RES,W,KNV,N,P,TAU,BMM,ADJUST,DDMAX)
      INTEGER N
      DOUBLE PRECISION RES(N+1),W(N+1)
      DOUBLE PRECISION P,TAU,DDMAX   
      INTEGER KNV(N)
      LOGICAL BMM,ADJUST
C
      DOUBLE PRECISION AK2,D,THRSH,THRSH1,VL,GAM
      INTEGER K,IK,IS,JJ,NK,LEN
C
C
C
      DDMAX=0D0
      TAU=3.47D0+35.7D0/DLOG(DBLE(N))**2
      THRSH1=DSQRT(TAU*DLOG(DBLE(N)))
      GAM=0.81D0+24D0/DLOG(DBLE(N))**3
      ADJUST=.FALSE.
C
      W(1)=0D0
      DO 10 I=2,N+1
         W(I)=W(I-1)+DBLE(I-1)*RES(I-1)
 10   CONTINUE
C
      DO 15 I=2,N+1
         RES(I)=RES(I)+RES(I-1)
 15   CONTINUE
C
      DO 20 I=N+1,2,-1
         RES(I)=RES(I-1)
 20   CONTINUE
      RES(1)=0D0
C
      THRSH1=DSQRT(TAU*DLOG(DBLE(N)))
      LENCOLD=0
      K=1
 30   CONTINUE
      IF(P**K.GE.DBLE(N)) RETURN
      AK2=P**(K-1)
      LEN=INT(AK2)
      IF(LEN.EQ.LENOLD) THEN
         K=K+1
         GOTO 30
      ENDIF
      LENOLD=LEN
      INC=MAX0(LEN/10,1)
      I=1
 40   CONTINUE
      IF(I+4*LEN.GT.N+3) GOTO 60
      D=W(I+2*LEN-1)-2D0*W(I+LEN)+W(I)-DBLE(I+2*LEN-1)*RES(I+2*LEN-1)
      D=D+DBLE(2*I+2*LEN+2)*RES(I+LEN)-DBLE(I-1)*RES(I)
      D=D-W(I+4*LEN-2)+2d0*W(I+3*LEN-1)-W(I+2*LEN-1)
      D=D+DBLE(I+4*LEN-2)*RES(I+4*LEN-2)
      D=D-DBLE(2*I+6*LEN)*RES(I+3*LEN-1)+DBLE(I+2*LEN-2)*RES(I+2*LEN-1)
      VL=DBLE(LEN)
      VL=2D0*VL*(VL+1D0)*(2D0*VL+1D0)/3D0+2D0*VL**2
      D=DABS(D)/DSQRT(VL)
      IF(BMM) THEN
         D=D-DSQRT(2D0*(DLOG(DBLE(N)/DBLE(LEN))))
         D=D/DLOG(DLOG(1.6D1*DBLE(N)/DBLE(LEN)))
         THRSH=GAM
      ELSE
         THRSH=THRSH1
      ENDIF
      DDMAX=DMAX1(DDMAX,D)
      IF(D.GT.THRSH) THEN
         DO 50 IJ=I,I+4*LEN-3
            KNV(IJ)=1
 50      CONTINUE
         ADJUST=.TRUE.
      ENDIF
 60   CONTINUE
      I=I+INC
      IF(I.GE.N-1) THEN
         K=K+1
         GOTO 30
      ENDIF
      GOTO 40
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE CNTRUN(X,KIND,N,RMAX,ADJUST)
      DOUBLE PRECISION X(N)
      INTEGER KIND(N)
      LOGICAL ADJUST
      INTEGER N,RMAX
C
      INTEGER IIL,IIR,IDL,IDR,I1,I2
      LOGICAL INCREASE, DECREASE
C
C
      IIL=1
      IDL=1
      IIR=1
      IDR=1
      ADJUST=.FALSE.
      INCREASE=.TRUE.
      DECREASE=.TRUE.
      DO 20 I=2,N
         I1=1
         I2=1
         IF(X(I).GT.X(I-1)) THEN
            IIR=I
            DECREASE=.FALSE.
            IDL=I
            IDR=I
         ELSEIF(X(I).LT.X(I-1)) THEN
            IDR=I
            INCREASE=.FALSE.
            IIL=I
            IIR=I
         ENDIF
         IF(IIR-IIL+1.GE.RMAX) THEN
            I1=IIL
            I2=IIR
         ELSEIF(IDR-IDL+1.GE.RMAX) THEN
            I1=IDL
            I2=IDR
         ENDIF
         IF(I2-I1.GT.0) THEN
            DO 10 K=I1,I2
               KIND(K)=1
 10         CONTINUE
            ADJUST=.TRUE.
         ENDIF
 20   CONTINUE
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE MONLSINT(SY,F,N,KNP,NPEAK,KNTS)
      INTEGER N,NPEAK
      DOUBLE PRECISION SY(N+1),F(N)
      INTEGER KNP(N+1),KNTS(N+1)
      LOGICAL ISO
C
      DOUBLE PRECISION FMIN,FMAX
C
C
      IF(NPEAK.EQ.0) THEN
         IF(F(1).LT.F(N)) THEN
           ISO=.TRUE.
           FMIN=F(1)
           FMAX=F(N)
           CALL  MONLS(SY,F,N,KNTS,FMIN,FMAX,ISO)
         ELSE
            ISO=.FALSE.
            FMIN=F(N)
            FMAX=F(1)
            CALL MONLS(SY,F,N,KNTS,FMIN,FMAX,ISO)
         ENDIF
         RETURN
      ENDIF
C
      NN=KNP(1)
      IF(F(1).LT.F(NN)) THEN
         ISO=.TRUE.
         FMIN=F(1)
         FMAX=F(NN)
         CALL  MONLS(SY,F,NN,KNTS,FMIN,FMAX,ISO)
      ELSE
         ISO=.FALSE.
         FMIN=F(NN)
         FMAX=F(1)
         CALL  MONLS(SY,F,NN,KNTS,FMIN,FMAX,ISO)
      ENDIF
C
      NN=KNP(NPEAK)
      NNN=N-NN+1
      IF(F(NN).LT.F(N)) THEN
         ISO=.TRUE.
         FMIN=F(NN)
         FMAX=F(N)
         CALL  MONLS(SY(NN),F(NN),NNN,KNTS,FMIN,FMAX,ISO)
      ELSE
         ISO=.FALSE.
         FMIN=F(N)
         FMAX=F(NN)
         CALL  MONLS(SY(NN),F(NN),NNN,KNTS,FMIN,FMAX,ISO)
      ENDIF
C
      IF(NPEAK.EQ.1) RETURN
C
      DO 10 NP=1,NPEAK-1
         NL=KNP(NP)
         NR=KNP(NP+1)
         NN=NR-NL+1
         IF(F(NL).LT.F(NR)) THEN
            ISO=.TRUE.
            FMIN=F(NL)
            FMAX=F(NR)
            CALL  MONLS(SY(NL),F(NL),NN,KNTS,FMIN,FMAX,ISO)
          ELSE
            ISO=.FALSE.
            FMIN=F(NR)
            FMAX=F(NL)
            CALL  MONLS(SY(NL),F(NL),NN,KNTS,FMIN,FMAX,ISO)
         ENDIF
 10   CONTINUE
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE MONLS(SY,F,N,KNTS,FMIN,FMAX,ISO)
      INTEGER N
      DOUBLE PRECISION SY(N+1),F(N)
      INTEGER KNTS(N+1)
      DOUBLE PRECISION FMIN,FMAX
      LOGICAL ISO
C
C
      IF(.NOT.ISO) THEN
         DO 5 I=1,N+1
            SY(I)=-SY(I)
 5       CONTINUE
      ENDIF
C
      NKNTS=2
      KNTS(1)=1
      KNTS(2)=2
      DO 10 I=3,N+1
         CALL LSTCNVX(SY,N+1,KNTS,NKNTS,I)
 10   CONTINUE
C
      DO 30 K=2,NKNTS
         SLP=(SY(KNTS(K-1))-SY(KNTS(K)))/DBLE(KNTS(K-1)-KNTS(K))
         DO 20 I=KNTS(K-1),KNTS(K)-1
            F(I)=SLP
 20      CONTINUE
 30   CONTINUE
     
C     
      IF(.NOT.ISO) THEN
         DO 35 I=1,N
            SY(I)=-SY(I)
            F(I)=-F(I)
 35      CONTINUE
         SY(N+1)=-SY(N+1)
      ENDIF
      IF(ISO) THEN
         F(1)=FMIN
         F(N)=FMAX
      ELSE
         F(1)=FMAX
         F(N)=FMIN
      ENDIF
c      return
      DO 40 I=1,N
         F(I)=DMAX1(F(I),FMIN)
         F(I)=DMIN1(F(I),FMAX)
 40   CONTINUE
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     THIS SUBROUTINE CALCULATES THE LARGEST CONVEX MINORANT OF THE
C     UPPER BOUNDARY UNTIL A POINT IS REACHED WHERE THIS IS LESS THAN 
C     THE LOWER BOUNDARY. THE POSITIONS OF THE KNOTS ARE STORED IN KN.
C 
      SUBROUTINE LSTCNVX(F,N,KN,K,I)
      DOUBLE PRECISION F(N)
      INTEGER KN(N)
C
C
      IF ((F(I)-F(KN(K)))/DBLE(I-KN(K)).GT.(F(KN(K))-F(KN(K-1)))/
     +     DBLE(KN(K)-KN(K-1))) THEN
         K=K+1
         KN(K)=I
         RETURN
      ENDIF
C
C                      ###BACKTRACK###
C
      JK=K-1
 20   CONTINUE
      IF(JK.EQ.1) GOTO 30
      IF ((F(I)-F(KN(JK)))/DBLE(I-KN(JK)).LT.(F(KN(JK))-F(KN(JK-1)))/
     +     DBLE(KN(JK)-KN(JK-1))) THEN
         JK=JK-1
         GOTO 20
      ENDIF
C
 30   CONTINUE
C
      K=JK+1
      KN(K)=I
C     
      END
C         
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      DOUBLE PRECISION FUNCTION SIGNUM(X)
      DOUBLE PRECISION X
C
      IF (X.GT.0D0) THEN
         SIGNUM=1D0
      ELSEIF (X.Lt.0D0) THEN
         SIGNUM=-1D0
      ELSE
         SIGNUM=0D0
      ENDIF
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
C
      SUBROUTINE CSTRING(L,U,N,KNX,KNV,KNSTR,NKNTS)
      INTEGER N
      DOUBLE PRECISION L(N),U(N)
      INTEGER KNX(N),KNV(N),KNSTR(N)
C
      INTEGER KV,KX,NFIX,NN,II,MNKN
      DOUBLE PRECISION ST1,ST2
      LOGICAL FIXSTR
C
C
C                 ###INITIALIZE###
C
      ST1=L(1)
      KV=2
      KX=2
      KNX(1)=1
      KNX(2)=2
      KNV(1)=1
      KNV(2)=2
      NFIX=1
      NKNTS=1
      KNSTR(1)=1
C
      I=2
 10   CONTINUE
      I=I+1
      NN=N-NFIX+1
      IF (I.GT.N) THEN
         IF(KNSTR(NKNTS).LT.N) THEN
            NKNTS=NKNTS+1
            KNSTR(NKNTS)=N
            RETURN
         ENDIF
      ENDIF
c      IF (I.GE.N) GOTO 20
      II=I-NFIX+1
      ST2=L(NFIX)
      L(NFIX)=ST1
      CALL FTCNCV(L(NFIX),NN,KNV,KV,II)
      L(NFIX)=ST2
      ST2=U(NFIX)
      U(NFIX)=ST1

      
      CALL FTCNVX(U(NFIX),NN,KNX,KX,II)
      U(NFIX)=ST2
C
 20   CONTINUE
C
      CALL CSTRING0(L(NFIX),U(NFIX),NN,ST1,KNX,KNV,FIXSTR)
C
      IF(.NOT.FIXSTR) GOTO 10
C
      MNKN=MIN0(KNX(2),KNV(2))
      NFIX=NFIX+MNKN-1
      NN=NN-MNKN+1
      NKNTS=NKNTS+1
      IF(MNKN.EQ.KNX(2)) THEN
         KNSTR(NKNTS)=NFIX
         KNV(1)=1
         DO 30 IJ=2,KV
            KNV(IJ)=KNV(IJ)-MNKN+1
 30      CONTINUE
         KX=KX-1
         DO 40 IJ=1,KX
            KNX(IJ)=KNX(IJ+1)-MNKN+1
 40      CONTINUE
      ELSE
         KNSTR(NKNTS)=-NFIX
         KNX(1)=1
         DO 50 IJ=2,KX
            KNX(IJ)=KNX(IJ)-MNKN+1
 50      CONTINUE
         KV=KV-1
         DO 60 IJ=1,KV
            KNV(IJ)=KNV(IJ+1)-MNKN+1
 60      CONTINUE
      ENDIF
C
      IF(NFIX.GT.N) RETURN
C
      GOTO 20
C
      END
C         
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     THIS SUBROUTINE CALCULATES THE SMALLEST CONCAVE MAJORANT OF THE
C     LOWER BOUNDARY UNTIL A POINT IS REACHED WHERE THIS IS GREATER THAN 
C     THE UPPER BOUNDARY. THE POSITIONS OF THE KNOTS ARE STORED IN KN. 
C
      SUBROUTINE FTCNCV(F,N,KN,K,I)
      DOUBLE PRECISION F(N)
      INTEGER KN(N)
C
C

      IF(I.GT.N) RETURN
      KN1=KN(1)
      KN(1)=1
C
      IF ((F(I)-F(KN(K)))/DBLE(I-KN(K)).LE.(F(KN(K))-F(KN(K-1)))
     +     /DBLE(KN(K)-KN(K-1))) THEN
         K=K+1
         KN(K)=I
         KN(1)=KN1
         RETURN
      ENDIF
C
C                      ###BACKTRACK###
C
      JK=K-1
 20   CONTINUE
      IF(JK.EQ.1) GOTO 30
      IF ((F(I)-F(KN(JK)))/DBLE(I-KN(JK)).GT.(F(KN(JK))-F(KN(JK-1)))/
     +     DBLE(KN(JK)-KN(JK-1))) THEN
         JK=JK-1
         GOTO 20
      ENDIF
C
 30   CONTINUE
C
      K=JK+1
      KN(K)=I
      KN(1)=KN1
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     THIS SUBROUTINE CALCULATES THE LARGEST CONVEX MINORANT OF THE
C     UPPER BOUNDARY UNTIL A POINT IS REACHED WHERE THIS IS LESS THAN 
C     THE LOWER BOUNDARY. THE POSITIONS OF THE KNOTS ARE STORED IN KN.
C 
      SUBROUTINE FTCNVX(F,N,KN,K,I)
      DOUBLE PRECISION F(N)
      INTEGER KN(N)
C
C
      IF(I.GT.N) RETURN
      KN1=KN(1)
      KN(1)=1
C
      IF ((F(I)-F(KN(K)))/DBLE(I-KN(K)).GE.(F(KN(K))-F(KN(K-1)))/
     +     DBLE(KN(K)-KN(K-1))) THEN
         K=K+1
         KN(K)=I
         KN(1)=KN1
         RETURN
      ENDIF
C
C                      ###BACKTRACK###
C
      JK=K-1
 20   CONTINUE
      IF(JK.EQ.1) GOTO 30
      IF ((F(I)-F(KN(JK)))/DBLE(I-KN(JK)).LT.(F(KN(JK))-F(KN(JK-1)))/
     +     DBLE(KN(JK)-KN(JK-1))) THEN
         JK=JK-1
         GOTO 20
      ENDIF
C
 30   CONTINUE
C
      K=JK+1
      KN(K)=I
      KN(1)=KN1
C     
      END
C         
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
      SUBROUTINE CSTRING0(L,U,N,STR1,KNX,KNV,FIXSTR)
      DOUBLE PRECISION L(N),U(N)
      INTEGER KNX(N),KNV(N)
      DOUBLE PRECISION STR1
      LOGICAL FIXSTR
C
      FIXSTR=.FALSE.
C
C        ###CHECK IF INITIAL GRADIENTS CONSISTENT###
C
      GRX1=(U(KNX(2))-STR1)/DBLE(KNX(2)-1)
      GRV0=(L(KNV(2))-STR1)/DBLE(KNV(2)-1)
C
C                   ###IF YES RETURN###
C
      IF (GRX1.GE.GRV0) RETURN
C
C                   ###IF NOT, FIX STRING###
C
      IF(KNX(2).LE.KNV(2)) THEN
         STR1=U(KNX(2))
      ELSE
         STR1=L(KNV(2))
      ENDIF
C
      FIXSTR=.TRUE.
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C     CALCULATE DERIVATIVE OF TAUT STRING
C
      SUBROUTINE CDSTRING(L,U,N,KNTS,NKNTS,F)
      DOUBLE PRECISION L(N),U(N),F(N)
      INTEGER KNTS(N)
C
      DOUBLE PRECISION B0,B1,D
C
C
C
      IF(KNTS(2).GT.0) THEN
         D=(U(KNTS(2))-U(1))/DBLE(KNTS(2)-1)
      ELSE
         D=(L(-KNTS(2))-U(1))/DBLE(-KNTS(2)-1)
      ENDIF
      DO 10 I=1,IABS(KNTS(2))-1
         F(I)=D
 10   CONTINUE
C
      IF(NKNTS.EQ.2) THEN
         F(N)=F(N-1)
         RETURN
      ENDIF
C
      IK=2
 20   CONTINUE
      IK=IK+1
      IF(IK.GE.NKNTS) GOTO 40
      KIK=IABS(KNTS(IK))
      KIK1=IABS(KNTS(IK-1))
      IF (KNTS(IK-1).GT.0.AND.KNTS(IK).GT.0) THEN
         B0=U(KIK1)
         B1=U(KIK)
      ELSEIF(KNTS(IK-1).LT.0.AND.KNTS(IK).LT.0) THEN
         B0=L(KIK1)
         B1=L(KIK)
      ELSE
         B0=(L(KIK1)+U(KIK1))/2D0
         B1=(L(KIK)+U(KIK))/2D0
      ENDIF

      D=(B1-B0)/DBLE(KIK-KIK1)
      DO 30 I=KIK1+1,KIK
         F(I-1)=D
 30   CONTINUE
      GOTO 20
C
 40   CONTINUE
      KIK=IABS(KNTS(IK))
      KIK1=IABS(KNTS(IK-1))
      IF (KNTS(IK-1).GT.0) THEN
         B0=U(KIK1)
      ELSE
         B0=L(KIK1)
      ENDIF
      B1=(L(KIK)+U(KIK))/2D0
      D=(B1-B0)/DBLE(KIK-KIK1)
      
      DO 50 I=KIK1+1,KIK
         F(I-1)=D
 50   CONTINUE
C

 60   CONTINUE
c      F(N)=F(N-1)
c      return
      IF(NKNTS.GE.3) THEN
c         write(*,*) NKNTS,KNTS(NKNTS-1)
         IF(KNTS(NKNTS-1).GT.0) THEN
            D=(U(N)-U(KNTS(NKNTS-1)))/DBLE(N-KNTS(NKNTS-1))
         ELSE
            D=(L(N)-L(-KNTS(NKNTS-1)))/DBLE(N+KNTS(NKNTS-1))
         ENDIF
         DO 15 I=IABS(KNTS(NKNTS-1)),N
            F(I)=D
 15      CONTINUE
      ENDIF
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C     CALCULATE TAUT STRING
C
      SUBROUTINE STRING(L,U,N,KNTS,NKNTS,TS)
      DOUBLE PRECISION L(N),U(N),TS(NKNTS)
      INTEGER KNTS(NKNTS)
C
      TS(1)=L(1)
      DO 10 I=2,NKNTS-1
         IF(KNTS(I).Gt.0) THEN
            TS(I)=U(KNTS(I))
         ELSE
            TS(I)=L(-KNTS(I))
         ENDIF
 10   CONTINUE
      TS(NKNTS)=L(N)
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE ADJSTBDS(L,U,N,KNV,SQZFAC,LCL)
      DOUBLE PRECISION L(N),U(N)
      INTEGER KNV(N)

      DOUBLE PRECISION SQZFAC
      LOGICAL LCL
C
      DOUBLE PRECISION D
      INTEGER KNVM
C
      IF(.NOT.LCL) GOTO 30
      KNVM=0
      DO 10 I=1,N
         KNVM=MAX0(KNVM,KNV(I))
 10   CONTINUE
      DO 20 J=1,N-1
         IF(KNV(J).EQ.1) THEN
            D=(U(J+1)-L(J+1))/2D0
            U(J+1)=U(J+1)-(1D0-SQZFAC)*D
            L(J+1)=L(J+1)+(1D0-SQZFAC)*D
c            IF(J.GE.2.AND.KNV(J-1).EQ.0) THEN
            IF(J.GE.2) THEN
               IF (KNV(J-1).EQ.0) THEN
                 D=(U(J)-L(J))/2D0
                 U(J)=U(J)-(1D0-SQZFAC)*D
                 L(J)=L(J)+(1D0-SQZFAC)*D
               ENDIF 
            ENDIF
         ENDIF
c         IF(KNV(J).GE.1) THEN
c         IF(KNV(J).EQ.KNVM) THEN
c            D=DBLE(KNV(J))*(U(J+1)-L(J+1))/DBLE(2*KNVM)
c            D=(U(J+1)-L(J+1))/2D0
c            U(J+1)=U(J+1)-(1D0-SQZFAC)*D
c            L(J+1)=L(J+1)+(1D0-SQZFAC)*D
c            IF(J.GE.2.AND.KNV(J-1).EQ.0) THEN
c               D=DBLE(KNV(J))*(U(J)-L(J))/DBLE(2*KNVM)
c               D=(U(J)-L(J))/2D0
c               U(J)=U(J)-(1D0-SQZFAC)*D
c               L(J)=L(J)+(1D0-SQZFAC)*D
c            ENDIF
c         ENDIF
 20   CONTINUE
      RETURN
C
 30   CONTINUE
C
      DO 40 J=1,N
         D=(U(J)-L(J))/2D0
         U(J)=U(J)-(1D0-SQZFAC)*D
         L(J)=L(J)+(1D0-SQZFAC)*D
 40   CONTINUE

      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE ISOB(F,N,LCPK,NKNTS,ISO)
      DOUBLE PRECISION F(N),ISO(N)
      INTEGER LCPK(1+NKNTS)
C
      DOUBLE PRECISION IS
C
C
      IF(NKNTS.EQ.0) THEN
         IF(F(1).LE.F(N)) THEN
            IS=1D0
         ELSE
            IS=-1D0
         ENDIF
         DO 10 I=1,N
            ISO(I)=IS
 10      CONTINUE
         RETURN
      ENDIF
C
      IF(F(1).LT.F(IABS(LCPK(1)))) THEN
         IS=1D0
      ELSE
         IS=-1D0
      ENDIF
      DO 20 I=1,LCPK(1)
         ISO(I)=IS
 20   CONTINUE
C
      IF(F(IABS(LCPK(NKNTS))).LT.F(N)) THEN
         IS=1D0
      ELSE
         IS=-1D0
      ENDIF
      DO 30 I=IABS(LCPK(NKNTS))+1,N
         ISO(I)=IS
 30   CONTINUE
C
      IF(NKNTS.EQ.1) RETURN
C
      DO 50 K=2,NKNTS
         IF(F(IABS(LCPK(K-1))).LT.F(K)) THEN
            IS=1D0
         ELSE
            IS=-1D0
         ENDIF
         DO 40 I=IABS(LCPK(K-1))+1,IABS(LCPK(K))
            ISO(I)=IS
 40      CONTINUE
 50   CONTINUE
C
      END
         
C      
C
C
      SUBROUTINE FCNST(X,FN,CM2,CM4,QNTL,QNTU,KNTS,ICNST,N,ALPHA)
      DOUBLE PRECISION X(N),FN(N),CM2(N+1),CM4(N+1),QNTL(N),QNTU(N)
      INTEGER KNTS(N)
      DOUBLE PRECISION ALPHA
C
      DOUBLE PRECISION MU
C
      CALL THRSHHLDC(QNTL,QNTU,N,ALPHA)
C
      CM2(1)=0D0
      CM4(1)=0D0
C
      DO 10 I=1,N
         CM2(I+1)=CM2(I)+X(I)**2
         CM4(I+1)=CM4(I)+X(I)**4
 10   CONTINUE
C
      CALL FCNST0(X,FN,CM2,QNTL,QNTU,KNTS,ICNST,N)
C
c      return
      CALL MINSQR(X,FN,CM2,CM4,KNTS,ICNST,N)
C  
C     ICNST changed to (ICNST-1) due to possible fortran array bound error
C
      DO 30 I=1,(ICNST-1)     
         MU=DSQRT((CM2(KNTS(I+1))-CM2(KNTS(I)))/DBLE(KNTS(I+1)-KNTS(I)))
         DO 20 J=KNTS(I),KNTS(I+1)-1
            FN(J)=MU
 20      CONTINUE
 30   CONTINUE
      
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE FCNST0(X,FN,CM2,QNTL,QNTU,KNTS,ICNST,N)
      DOUBLE PRECISION X(N),FN(N),CM2(N+1),QNTL(N),QNTU(N)
      INTEGER KNTS(N)
C
      DOUBLE PRECISION MU,MUMAX,MUMIN,MUMAX0,MUMIN0
C
      ICNST=1
C
C
      I=1
      J=1
      KNTS(1)=1
      MUMAX=X(1)**2/QNTL(1)
      MUMIN=X(1)**2/QNTU(1)
C
 20   CONTINUE
C
      MUMIN0=MUMIN
      MUMAX0=MUMAX
      IF(J.LT.N) THEN
         J=J+1
      ELSE
         GOTO 40
      ENDIF
C
      CALL CNST(X,CM2,QNTL,QNTU,N,MUMAX,MUMIN,I,J)
C

C
      MU=(CM2(J+1)-CM2(I))/DBLE(J+1-I)
      IF (MUMIN.LT.MU.AND.MUMAX.GT.MU) GOTO 20
      ICNST=ICNST+1
C
      MU=DSQRT((CM2(J)-CM2(I))/DBLE(J-I))
      DO 30 K=I,J-1
         FN(K)=MU
 30   CONTINUE
      KNTS(ICNST)=J
C
      I=J
      MUMAX=X(I)**2/QNTL(1)
      MUMIN=X(I)**2/QNTU(1)
      GOTO 20
C
 40   CONTINUE
      MU=DSQRT((CM2(N+1)-CM2(I))/DBLE(N+1-I))
      DO 50 K=I,N
         FN(K)=MU
 50   CONTINUE
      ICNST=ICNST+1
      KNTS(ICNST)=N+1
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE CNST(X,CM2,QNTL,QNTU,N,MUMAX,MUMIN,I,J)
      DOUBLE PRECISION X(N),CM2(N+1),QNTL(N),QNTU(N)
      DOUBLE PRECISION MUMAX,MUMIN
C
      DOUBLE PRECISION MUL,MUU
C
C
      DO 10 K=J,I,-1
         SS=CM2(J+1)-CM2(K)
         MUMAX=DMIN1(MUMAX,SS/QNTL(J+1-K))
         MUMIN=DMAX1(MUMIN,SS/QNTU(J+1-K))
 10   CONTINUE
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE MINSQR(X,FN,CM2,CM4,KNTS,ICNST,N)
      DOUBLE PRECISION X(N),FN(N),CM2(N+1),CM4(N+1)
      INTEGER KNTS(ICNST)
C
C
      DO 10 I=ICNST-1,2,-1
         CALL MVLFT(X,FN,CM2,CM4,KNTS,ICNST,N,I)
 10   CONTINUE
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE MVLFT(X,FN,CM2,CM4,KNTS,ICNST,N,IL)
      DOUBLE PRECISION X(N),FN(N),CM2(N+1),CM4(N+1)
      INTEGER KNTS(ICNST)
C
      DOUBLE PRECISION SIG1,SIG2
C
      IF(KNTS(IL-1).EQ.KNTS(IL)-1) RETURN
C
      JL1=KNTS(IL-1)
      JL2=KNTS(IL)-1
      JL3=KNTS(IL+1)
C
 10   CONTINUE
      IF(JL1.EQ.JL2) THEN
         KNTS(IL)=JL2+1
         RETURN
      ENDIF
C         
      SIG1=CM4(JL2+1)-CM4(JL1)-(CM2(JL2+1)-CM2(JL1))**2/DBLE(JL2+1-JL1)
      SIG1=SIG1+CM4(JL3)-CM4(JL2+1)-(CM2(JL3)-CM2(JL2+1))**2/
     $                                   DBLE(JL3-JL2-1)
C
      IL1=JL1
      IL2=JL2-1
      IL3=JL3
      SIG2=CM4(IL2+1)-CM4(IL1)-(CM2(IL2+1)-CM2(IL1))**2/DBLE(IL2+1-IL1)
      SIG2=SIG2+CM4(IL3)-CM4(IL2+1)-(CM2(IL3)-CM2(IL2+1))**2/
     $                                   DBLE(IL3-IL2-1)
C
      IF(SIG1.LE.SIG2) THEN
         KNTS(IL)=JL2+1
         RETURN
      ENDIF
C
      JL2=IL2
      GOTO 10
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE KMEAN(X,MU,S1,S2,N,K)
      DOUBLE PRECISION X(N),MU(N),S1(N+1),S2(N+1)
C
      DOUBLE PRECISION VMIN,V1,V2
C
C
      S1(1)=0D0
      S2(1)=0D0
      DO 10 I=1,N
         S1(I+1)=S1(I)+X(I)
         S2(I+1)=S2(I)+X(I)**2
 10   CONTINUE
C
      VMIN=1D35
C
      DO 20 I=1,N-1
         V1=S2(I+1)-S1(I+1)**2/DBLE(I)
         V2=S2(N+1)-S2(I+1)-(S1(N+1)-S1(I+1))**2/DBLE(N-I)
         IF(V1+V2.LT.VMIN) THEN
            K=I
            MU(1)=S1(I+1)/DBLE(I)
            MU(2)=(S1(N+1)-S1(I+1))/DBLE(N-I)
            VMIN=V1+V2
         ENDIF
 20   CONTINUE
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE THRSHHLDC(QNTL,QNTU,N,ALPHA)
      DOUBLE PRECISION QNTL(N),QNTU(N)
      DOUBLE PRECISION ALPHA
C
      DOUBLE PRECISION AI,BETA1,BETA2
      DOUBLE PRECISION QUGAMMA
C
C
      IF(ALPHA.LT.0D0) THEN
         BETA2=-ALPHA
         BETA1=1D0-BETA2
      ELSE
         BETA2=1D0-(1D0-ALPHA)/DBLE(2*N)
         BETA1=1D0-BETA2
      ENDIF
C
C
      DO 10 I=1,N
         AI=DBLE(I)/2D0
         QNTL(I)=2D0*QUGAMMA(BETA1,AI)
         QNTU(I)=2D0*QUGAMMA(BETA2,AI)
 10   CONTINUE
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      DOUBLE PRECISION	FUNCTION PRGAU(X)
      DOUBLE PRECISION X
      DOUBLE PRECISION B(5),RT2PI,P,S,T,Y

      DATA B/.31938153D0,-.356563782D0,1.781477937D0,-1.821255978D0,
     *	     1.330274429D0/,RT2PI/2.506628275D0/,P/.2316419D0/

      Y=DABS(X)
      IF(Y.GT.1D1) THEN
	   PRGAU=1D0
      ELSE
	   T=(1D0+P*Y)**(-1)
           S=B(1)*T+B(2)*T**2+B(3)*T**3+B(4)*T**4+B(5)*T**5
	   PRGAU=1D0-DEXP(-0.5D0*Y**2)*S/RT2PI
      ENDIF
      IF(X.GE.0D0) RETURN
      PRGAU=1D0-PRGAU
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      DOUBLE PRECISION FUNCTION PRGAMMA(X,AK)
      DOUBLE PRECISION X,AK
C
      DOUBLE PRECISION A,AAK,DF,Y
      DOUBLE PRECISION GAMMA,KH0,PRGAU
C
      IF(AK.GE.3D1.OR.DABS(X-AK).GE.2D0*DSQRT(AK)) THEN
         Y=X/AK
         PRGAMMA=PRGAU(DSQRT(2D0)*KH0(Y,AK))
      ELSE
         J=1
 10      CONTINUE
         IF(AK+DBLE(J).LT.3D1) THEN
            J=J+1
            GOTO 10
         ENDIF
         AAK=AK+DBLE(J)
         SUM=1D0
         A=1D0
         DO 20 I=1,J-1
            A=A*X/(AK+DBLE(I))
            SUM=SUM+A
 20      CONTINUE
         SUM=SUM*DEXP(AK*DLOG(X)-X)/GAMMA(AK+1D0)
         Y=X/AAK
         PRGAMMA=SUM+PRGAU(DSQRT(2D0)*KH0(Y,AAK))
      ENDIF
C      
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
      DOUBLE PRECISION FUNCTION KH0(X,AK)
      DOUBLE PRECISION X,AK
C
      DOUBLE PRECISION XMN,Y
C
C
      IF(DABS(X-1D0).GT.1D-3) THEN
         KH0=(X-1D0)**2/(X-1D0-DLOG(X))
         KH0=0.5D0*DLOG(KH0/2D0)
      ELSE
         KH0=0D0
      ENDIF
C
      KH0=KH0+AK*(X-1D0-DLOG(X))
      CALL KH0MIN(AK,XMN,Y)
      KH0=DSQRT(DMAX1(0D0,KH0-Y))
      IF(X.LT.XMN) KH0=-KH0
C      
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
      DOUBLE PRECISION FUNCTION KH01(X,AK)
      DOUBLE PRECISION X,AK
C
C
C
      IF(DABS(X-1D0).GT.1D-3) THEN
         KH01=2D0*X*(X-1D0-DLOG(X))-(X-1D0)**2
         KH01=KH01/(2D0*(X-1D0)*(X-1D0-DLOG(X)))
      ELSE
         KH01=(1D0-2D0*(X-1D0))/(3D0*X*(1D0-2D0*(X-1D0)/3D0))
      ENDIF
C
      KH01=KH01+AK*(X-1D0)/X
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE KH0MIN(AK,XMIN,Y)
      DOUBLE PRECISION AK,XMIN,Y
C
      DOUBLE PRECISION X0,X1,X2
      DOUBLE PRECISION KH01
C
C
      X1=1D0
      X0=1D0
 10   CONTINUE
      X0=X0/2D0
      Y=KH01(X0,AK)
      IF(Y.GT.0D0) GOTO 10
C
 20   CONTINUE
      X2=(X0+X1)/2D0
      IF(X1-X0.LT.1D-12) THEN
         XMIN=(X0+X1)/2D0
         GOTO 30
      ENDIF
      Y=KH01(X2,AK)
      IF(Y.GT.0D0) THEN
         X1=X2
      ELSE
         X0=X2
      ENDIF
      GOTO 20
C
 30   CONTINUE
C
      IF(DABS(XMIN-1D0).GT.1D-8) THEN
         Y=(XMIN-1D0)**2/(XMIN-1D0-DLOG(XMIN))
         Y=0.5D0*DLOG(Y/2D0)
      ELSE
         KH0=0D0
      ENDIF
C
      Y=Y+AK*(XMIN-1D0-DLOG(XMIN))
C
      END

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      DOUBLE PRECISION FUNCTION QUGAMMA(P,K)
      DOUBLE PRECISION P,K
C
      DOUBLE PRECISION X0,X1,X2,Y
      DOUBLE PRECISION PRGAMMA
C
C
      X0=K
      Y=PRGAMMA(X0,K)
      IF(Y.LT.P) THEN
         X1=X0
 10      CONTINUE
         X1=2D0*X1
         Y=PRGAMMA(X1,K)
         IF(Y.LE.P) GOTO 10
      ELSE
         X1=X0
 20      CONTINUE
         X0=X0/2D0
         Y=PRGAMMA(X0,K)
         IF(Y.GE.P) GOTO 20
      ENDIF
C
 30   CONTINUE
      X2=(X1+X0)/2D0
      Y=PRGAMMA(X2,K)
      IF(DMAX1(DABS(Y/P-1D0),DABS((1D0-Y)/(1D0-P)-1D0)).LE.1D-5) THEN
         QUGAMMA=X2
         RETURN
      ENDIf
      IF(Y.GE.P) THEN
         X1=X2
      ELSE
         X0=X2
      ENDIF
      GOTO 30
C
      END

      
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
C
      DOUBLE PRECISION FUNCTION GAMMA(K)
      DOUBLE PRECISION K
C
      DOUBLE PRECISION A,R2PI
C
      R2PI= 2.50662827463D0
C
C
      IF(K.GE.5D0) THEN
         A=K-1D0
         GAMMA=R2PI*DSQRT(A)*DEXP(A*DLOG(A)-A+1D0/(12D0*A)
     +        -1D0/(360D0*A**3))
      ELSEIF(K.GE.4D0) THEN
         GAMMA=R2PI*DSQRT(K)*DEXP(K*DLOG(K)-K+1D0/(12D0*K)
     +        -1D0/(360D0*K**3))
         GAMMA=GAMMA/K
      ELSEIF(K.GE.3D0) THEN
         A=K+1D0
         GAMMA=R2PI*DSQRT(A)*DEXP(A*DLOG(A)-A+1D0/(12D0*A)
     +        -1D0/(360D0*A**3))
         GAMMA=GAMMA/(K*(K+1D0))
      ELSEIF(K.GE.2D0) THEN
         A=K+2D0
         GAMMA=R2PI*DSQRT(A)*DEXP(A*DLOG(A)-A+1D0/(12D0*A)
     +        -1D0/(360D0*A**3))
         GAMMA=GAMMA/(K*(K+1D0)*(K+2D0))
      ELSEIF(K.GE.1D0) THEN
         A=K+3D0
         GAMMA=R2PI*DSQRT(A)*DEXP(A*DLOG(A)-A+1D0/(12D0*A)
     +        -1D0/(360D0*A**3))
         GAMMA=GAMMA/(K*(K+1D0)*(K+2D0)*(K+3D0))
      ELSE
         A=K+4D0
         GAMMA=R2PI*DSQRT(A)*DEXP(A*DLOG(A)-A+1D0/(12D0*A)
     +        -1D0/(360D0*A**3))
         GAMMA=GAMMA/(K*(K+1D0)*(K+2D0)*(K+3D0)*(K+4D0))
      ENDIF
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE VOLDIST(V,N,FV,NFV,LFAC,RFAC)
      DOUBLE PRECISION V(N),FV(NFV,2)
      DOUBLE PRECISION LFAC,RFAC
C
      DOUBLE PRECISION FACL,FACR,RNG,X,XL,XR
C
C     RANGE OF VOLATILITIES
C
      FACL=DLOG(LFAC)
      FACR=DLOG(RFAC)
      RNG=V(N)+FACR-V(1)-FACL
C
      I=1
 10   CONTINUE
      X=V(1)+FACL+DBLE(I-1)*RNG/DBLE(NFV)
      XL=V(1)+FACL
      XR=0.5D0*(V(1)+V(2))
      IF(X.LE.XR) THEN
         FV(I,1)=X
         FV(I,2)=(X-XL)/((XR-XL)*DBLE(N))
         I=I+1
         GOTO 10
      ENDIF
C
      J=2
 20   CONTINUE
      IF(J.EQ.N) GOTO 30
      X=V(1)+FACL+DBLE(I-1)*RNG/DBLE(NFV)
      XL=0.5D0*(V(J-1)+V(J))
      XR=0.5D0*(V(J)+V(J+1))
      IF(X.LE.XR) THEN
         FV(I,1)=X
         FV(I,2)=DBLE(J-1)/DBLE(N)+(X-XL)/((XR-XL)*DBLE(N))
         I=I+1
         GOTO 20
      ENDIF
      J=J+1
      GOTO 20
C
 30   CONTINUE
      IF(I.EQ.NFV+1) RETURN
      X=V(1)+FACL+DBLE(I-1)*RNG/DBLE(NFV)
      XL=0.5D0*(V(N-1)+V(N))
      XR=V(N)+FACR
      IF(X.LE.XR) THEN
         FV(I,1)=X
         FV(I,2)=DBLE(J-1)/DBLE(N)+(X-XL)/((XR-XL)*DBLE(N))
         I=I+1
         GOTO 30
      ENDIF
C
      END
      
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
C
      SUBROUTINE VOLRV(PR,N,FV,NFV,RV)
      DOUBLE PRECISION PR(N),RV(N)
      DOUBLE PRECISION FV(NFV,2)
C
C
C
      DO 20 I=1,N
         J=1
 10      CONTINUE
         IF(PR(I).GE.FV(J,2)) THEN
            J=J+1
            GOTO 10
         ENDIF
         RV(I)=(FV(J-1,1)+FV(J,1))/2D0
 20   CONTINUE
C
      END
      
        
