% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{diffObj}
\alias{diffObj}
\title{Diff Objects}
\usage{
diffObj(target, current, ...)
}
\arguments{
\item{target}{the reference object}

\item{current}{the object being compared to \code{target}}

\item{...}{unused, for compatibility of methods with generics}
}
\value{
a \code{Diff} object; see \code{\link{diffPrint}}.
}
\description{
Compare either the \code{print}ed or \code{str} screen representation of
R objects depending on which is estimated to produce the most useful
diff.  The selection process tries to minimize screen lines while maximizing
differences shown subject to display constraints.  The decision algorithm is
likely to evolve over time, so do not rely on this function making
a particular selection under specific circumstances.  Instead, use
\code{\link{diffPrint}} or \code{\link{diffStr}} if you require one or the
other output.
}
\examples{
## `pager="off"` for CRAN compliance; you may omit in normal use
diffObj(letters, c(letters[1:10], LETTERS[11:26]), pager="off")
with(mtcars, diffObj(lm(mpg ~ hp)$qr, lm(mpg ~ disp)$qr, pager="off"))
}
\seealso{
\code{\link{diffPrint}} for details on the \code{diff*} methods,
  \code{\link{diffStr}},
  \code{\link{diffChr}} to compare character vectors directly
  \code{\link{diffDeparse}} to compare deparsed objects,
  \code{\link{ses}} for a minimal and fast diff
}

