% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/did.R
\name{compute.mp.spatt}
\alias{compute.mp.spatt}
\title{compute.mp.spatt}
\usage{
compute.mp.spatt(flen, tlen, flist, tlist, data, dta, first.treat.name,
  formla, xformla, tname, w, panel, idname, method, seedvec, se, pl, cores,
  printdetails)
}
\arguments{
\item{data}{The name of the data.frame that contains the data}

\item{first.treat.name}{The name of the variable in \code{data} that contains the first
period when a particular observation is treated.  This should be a positive
number for all observations in treated groups.  It should be 0 for observations
in the untreated group.}

\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary)}

\item{xformla}{A optional one sided formula for additional covariates that
will be adjusted for.  E.g ~ age + education.  Additional covariates can
also be passed by name using the x paramater.}

\item{tname}{The name of the column containing the time periods}

\item{w}{A vector of weights for each observation (not implemented)}

\item{panel}{Boolean indicating whether the data is panel or repeated cross
sections}

\item{idname}{The individual (cross-sectional unit) id name}

\item{method}{The method for estimating the propensity score when covariates
are included}

\item{seedvec}{Optional value to set random seed; can possibly be used
in conjunction with bootstrapping standard errors#' (not implemented)}

\item{se}{Boolean whether or not to compute standard errors}

\item{pl}{Boolean for whether or not to use parallel processing}

\item{cores}{The number of cores to use for parallel processing}

\item{printdetails}{Boolean for showing detailed results or not}
}
\value{
a list with length equal to the number of groups times the
 number of time periods; each element of the list contains a \code{QTE}
 object that contains group-time average treamtent effect as well
 as which group it is for and which time period it is for and
 the influence function which is used externally to compute
 standard errors.
}
\description{
\code{compute.mp.spatt} does the main work for computing
 mutliperiod group-time average treatment effects
}
\keyword{internal}
