% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{geom_dice_sf}
\alias{geom_dice_sf}
\title{Plot Dice Representations on sf Objects}
\usage{
geom_dice_sf(
  sf_data,
  dice_value_col = "dice",
  face_color = NULL,
  dice_color = "white",
  dice_size = 3,
  dot_size = NULL,
  rectangle_padding = 0.05,
  ...
)
}
\arguments{
\item{sf_data}{An sf object containing the spatial features.}

\item{dice_value_col}{Character. Name of the column in sf_data containing dice values (1-6).
Default is "dice".}

\item{face_color}{Character vector. Column names in sf_data containing color information
for each dice dot. If NULL (default), all dots are black.}

\item{dice_color}{Character. Background color of the dice. Default is "white".}

\item{dice_size}{Numeric. Size of the dice. Default is 3.}

\item{dot_size}{Numeric. Size of the dots on the dice. If NULL (default),
it's calculated as 20\% of dice_size.}

\item{rectangle_padding}{Numeric. Padding of the rectangle around the dots, as a
proportion of dice_size. Default is 0.05.}

\item{...}{Additional arguments passed to geom_point for the dots.}
}
\value{
A list of ggplot2 layers (rectangle layer and dots layer).
}
\description{
Creates a ggplot2 layer that places dice representations on spatial features
in an sf object. The dice values are determined by a column in the sf object.
}
\examples{
\dontrun{
library(ggplot2)
library(sf)

# Create sample sf data with dice values
nc <- st_read(system.file("shape/nc.shp", package = "sf"))
nc$dice <- sample(1:6, nrow(nc), replace = TRUE)

# Basic plot with dice
ggplot(nc) + 
  geom_sf() + 
  geom_dice_sf(sf_data = nc)
  
# Customized dice
ggplot(nc) + 
  geom_sf() + 
  geom_dice_sf(sf_data = nc, dice_color = "lightblue", dice_size = 5)
}

}
