% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_funs.R
\name{k_modes}
\alias{k_modes}
\title{K-modes}
\usage{
k_modes(E, is.relabelled = TRUE, seed = 1)
}
\arguments{
\item{E}{a matrix of clusterings with number of rows equal to the number of
cases to be clustered, number of columns equal to the clustering obtained
by different resampling of the data, and the third dimension are the
different algorithms. Matrix may already be two-dimensional.}

\item{is.relabelled}{logical; if \code{FALSE} the data will be relabelled using
the first clustering as the reference.}

\item{seed}{random seed for reproducibility}
}
\value{
a vector of cluster assignments based on k-modes
}
\description{
Combine clustering results using K-modes.
}
\details{
Combine clustering results generated using different algorithms and different
data perturbations by k-modes. This method is the categorical data analog of
k-means clustering. Complete cases are needed: i.e. no \code{NA}s. If the matrix
contains \code{NA}s those are imputed by majority voting (after class relabeling).
}
\examples{
data(hgsc)
dat <- hgsc[1:100, 1:50]
cc <- consensus_cluster(dat, nk = 4, reps = 6, algorithms = "pam", progress =
FALSE)
table(k_modes(cc[, , 1, 1, drop = FALSE], is.relabelled = FALSE))
}
\seealso{
Other consensus functions: \code{\link{CSPA}},
  \code{\link{LCA}}, \code{\link{LCE}},
  \code{\link{majority_voting}}
}
\author{
Aline Talhouk
}
\concept{consensus functions}
