% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_neighbors.R
\name{neighbors}
\alias{neighbors}
\title{Number of neighbors}
\usage{
neighbors(range = c(1L, 10L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
The number of neighbors is used for models (\code{parsnip::nearest_neighbor()}),
imputation (\code{recipes::step_impute_knn()}), and dimension reduction
(\code{recipes::step_isomap()}).
}
\details{
A static range is used but a broader range should be used if the data set
is large or more neighbors are required.
}
\examples{
neighbors()
}
