
<!-- README.md is generated from README.Rmd. Please edit that file -->

# dials

[![R-CMD-check](https://github.com/tidymodels/dials/workflows/R-CMD-check/badge.svg)](https://github.com/tidymodels/dials/actions)
[![Codecov test
coverage](https://codecov.io/gh/tidymodels/dials/branch/main/graph/badge.svg)](https://app.codecov.io/gh/tidymodels/dials?branch=main)
[![CRAN_Status_Badge](http://www.r-pkg.org/badges/version/dials)](https://CRAN.R-project.org/package=dials)
[![Downloads](http://cranlogs.r-pkg.org/badges/dials)](https://CRAN.R-project.org/package=dials)
[![lifecycle](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html)

## Overview

This package contains *infrastructure* to create and manage values of
tuning parameters for the tidymodels packages. If you are looking for
*how to* tune parameters in tidymodels, please look at the
[tune](https://tune.tidymodels.org/) package and
[tidymodels.org](https://www.tidymodels.org/).

The name reflects the idea that tuning predictive models can be like
turning a set of dials on a complex machine under duress.

<img src="http://tos.trekcore.com/hd/albums/1x04hd/thenakedtimehd1013.jpg" width="576">

## Installation

You can install the released version of dials from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("dials")
```

You can install the development version from Github with:

``` r
devtools::install_github("tidymodels/dials")
```

## Contributing

This project is released with a [Contributor Code of
Conduct](https://contributor-covenant.org/version/2/0/CODE_OF_CONDUCT.html).
By contributing to this project, you agree to abide by its terms.

-   For questions and discussions about tidymodels packages, modeling,
    and machine learning, please [post on RStudio
    Community](https://community.rstudio.com/new-topic?category_id=15&tags=tidymodels,question).

-   If you think you have encountered a bug, please [submit an
    issue](https://github.com/tidymodels/dials/issues).

-   Either way, learn how to create and share a
    [reprex](https://reprex.tidyverse.org/articles/articles/learn-reprex.html)
    (a minimal, reproducible example), to clearly communicate about your
    code.

-   Check out further details on [contributing guidelines for tidymodels
    packages](https://www.tidymodels.org/contribute/) and [how to get
    help](https://www.tidymodels.org/help/).
