% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fitted.dfrr.R
\name{plot.fitted.dfrr}
\alias{plot.fitted.dfrr}
\title{Plot dfrr fitted latent functions}
\usage{
\method{plot}{fitted.dfrr}(
  x,
  id = NULL,
  main = NULL,
  col = "blue",
  lwd = 2,
  lty = "solid",
  cex.circle = 1,
  col.circle = "black",
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{the output of the function \link{fitted.dfrr}}

\item{id}{a vector of length one or more containing subject ids to plot. Must be matched with
\code{rownames(<response>)} or the \code{.obs} column of \code{ydata}. Defaults to
 all  subject ids.}

\item{main}{a vector of length one or \code{length(id)} containing the title of
plots.}

\item{col, lwd, lty, ...}{graphical parameters passed to \code{\link{plot}}}

\item{cex.circle, col.circle}{size and color of circles and filled circles.}

\item{ylim}{a vector of length two indicating the range of y-axis of the plot.}
}
\value{
This function generates plot of fitted curves.
}
\description{
Plot a  \code{fitted.dfrr} object.
}
\details{
The output is the plot of latent curves over the observed binary sequence.
The binary sequence is illustrated with circles and filled circles for the values
of zero and one, respectively.
}
\examples{
set.seed(2000)
\donttest{N<-50;M<-24}
\dontshow{N<-30;M<-12}
X<-rnorm(N,mean=0)
time<-seq(0,1,length.out=M)
Y<-simulate_simple_dfrr(beta0=function(t){cos(pi*t+pi)},
                        beta1=function(t){2*t},
                        X=X,time=time)

#The argument T_E indicates the number of EM algorithm.
#T_E is set to 1 for the demonstration purpose only.
#Remove this argument for the purpose of converging the EM algorithm.
dfrr_fit<-dfrr(Y~X,yind=time,T_E=1)
fitteds<-fitted(dfrr_fit)
plot(fitteds)

}
