% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\docType{class}
\name{dosefinding-class}
\alias{dosefinding-class}
\title{An S4 class to represent a dosefinding results.}
\description{
An S4 class to represent a dosefinding results.
}
\section{Slots}{

\describe{
\item{\code{pid}}{Patient's ID provided in the study.}

\item{\code{N}}{The total number of patients.}

\item{\code{time}}{The time sampling.}

\item{\code{doses}}{The dose levels of the drug.}

\item{\code{conc}}{Concentration of the drug.}

\item{\code{p0}}{The skeleton of CRM.}

\item{\code{L}}{A threshold set before starting the trial.}

\item{\code{nchains}}{Number of chains for the stan model.}

\item{\code{niter}}{Number of iterations for the stan model.}

\item{\code{nadapt}}{Number of warmup iterations for the stan model.}

\item{\code{newDose}}{The next maximum tolerated dose (MTD).}

\item{\code{theta}}{The toxicity (probability) target.}

\item{\code{doseLevels}}{A vector of dose levels assigned to patients in the trial.}

\item{\code{toxicity}}{The toxicity outcome.}

\item{\code{AUCs}}{A vector with the computed AUC values of each patient.}

\item{\code{TR}}{The number of replicates clinical trials.}

\item{\code{preal}}{The real probability of toxicity.}

\item{\code{pstim}}{The estimated mean probabilities of toxicity.}

\item{\code{pstimQ1}}{The 1st quartile of estimated probability of toxicity.}

\item{\code{pstimQ3}}{The 3rd quartile of estimated probability of toxicity.}

\item{\code{model}}{A character string to specify the working model used in the method.}
}}

