% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzc_mat_vis.r
\name{nzc_vis}
\alias{nzc_vis}
\title{Non-zero coverage correlation matrix visualization}
\usage{
nzc_vis(coverage.tbl.list, model_results, roi, ntps.per.scan,
  save_fig = FALSE, output_dir = NULL, alpha = 0.05,
  thres.cond1 = 0.5, thres.cond2 = 0.5, thres.diff = 0.1)
}
\arguments{
\item{coverage.tbl.list}{A list with a list of zero-coverage table, can be obtained from \code{data_summary_coverage}.}

\item{model_results}{data frame, output of either \code{lmmConn} or \code{lmmDyn}.}

\item{roi}{integer vector, specify the list of regions of interests.}

\item{ntps.per.scan}{integer, number of timepoints per scan.}

\item{save_fig}{logical, whether to save the figures locally.}

\item{output_dir}{character string, output directory of figures to save.}

\item{alpha}{alpha level of proportion-testing, default is 0.05.}

\item{thres.cond1}{numeric, threshold for cond1 flavor proportion-test, default is 0.5.}

\item{thres.cond2}{numeric, threshold for cond2 flavor proportion-test, default is 0.5.}

\item{thres.diff}{numeric, threshold for proportion-test of difference between condition 1 and condition 2 .}
}
\description{
Visualize non-zero coverage of dynamic functional connectivity modeling estimates.
}
\examples{
# load sample summary of the linear mixed model output
data(coverage.tbl.list)
data(DynModel_results)
nzc_vis(coverage.tbl.list, DynModel_results$modelDyn_results,
        roi=c(54,191,235), DynModel_results$params$ntp_per_scan, save_fig=FALSE)
\dontshow{
rm(list=c('DynModel_results','coverage.tbl.list'))
gc()}       
}
