% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLPB3.R
\name{MLPB3}
\alias{MLPB3}
\title{Multivariate Linear Bootstrapping - core function}
\usage{
MLPB3(X, Boot, l = 1, eps = 1, beta = 1, l_automatic = 0,
  l_automatic_local = 0)
}
\arguments{
\item{X}{data matrix}

\item{Boot}{integer, number of bootstrap samples to be generated}

\item{l}{numeric, the banding parameter, default is 1}

\item{eps}{numeric the parameters for making Gamma_kappa_matrix positive definite if necessary, default is 1;}

\item{beta}{numeric the parameters for making Gamma_kappa_matrix positive definite if necessary, default is 1;}

\item{l_automatic}{numeric the banding parameter, default is 1, data-adaptively;}

\item{l_automatic_local}{numeric, the banding parameter default is 0}
}
\value{
a numeric matrix with n*boot rows and m columns, where n, m refer to the number of rows and number of columns in input data matrix, and boot refer to number of bootstrap samples to be generated.
}
\description{
Multivariate Linear Bootstrapping - core function
}
\examples{
# Multivariate linear bootstrapping on a random matrix with 2 rows and 4 columns
MLPB3(matrix(rnorm(16),2,4), 3)

}
