% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option_control.R
\name{options_lme}
\alias{options_lme}
\title{Options control - Linear mixed model}
\usage{
options_lme(effective_tp, num.scan, ntps.per.scan, output_dir = NULL,
  subjects = NULL, ci_level = 0.975, numIntKnots = 40, cores = 1,
  ngrid = 201, seed = 1114)
}
\arguments{
\item{effective_tp}{integer, effective scan time points.}

\item{num.scan}{integer, number of scan.}

\item{ntps.per.scan}{integer, number of timepoints per scan.}

\item{output_dir}{string, directory for storing output files.}

\item{subjects}{character vector, names of subjects.}

\item{ci_level}{numeric, level of confidence interval, with default 0.975.}

\item{numIntKnots}{integer, number of knots for O’Sullivan penalized splines, default is 40}

\item{cores}{integer, number of cores to register while running parallel jobs.}

\item{ngrid}{integer, number of grids.}

\item{seed}{integer, random seed.}
}
\value{
A list of options
}
\description{
Options control for running linear mixed model.
}
\examples{
data("MLPB_output_median")

subjects <- c('subject1', 'subject2', 'subject3', 'subject4', 'subject5')

# In our demo data, each subject has a scan with a total of 750 time points
time.points <- c(1:105, 126:230, 251:355,
                 376:480, 501:605, 626:730) 
                 
                 
num.scan <- 6 # Each subject has 6 scans
ntps.per.scan <- 105 # Each scan has 105 time points

op <- options_lme(effective_tp = time.points, 
                 ntps.per.scan = ntps.per.scan,
                 subjects = subjects, 
                 num.scan = num.scan, 
                 cores = 5)
\dontshow{
rm(list = c("MLPB_output_median","op"))
gc()
}
}
