% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme_model0.r
\name{lmmConn}
\alias{lmmConn}
\title{Semiparametric modelling - Static}
\usage{
lmmConn(dataList, subjects, eff_time_points, num.scan, ntps.per.scan,
  save_res = FALSE, output_dir = NULL, ci_level = 0.975,
  ngrid = 201, cores = 1, seed = NULL)
}
\arguments{
\item{dataList}{list, list of data matrices .}

\item{subjects}{character vector, names of subjects.}

\item{eff_time_points}{integer vector, effective sacn timepoints.}

\item{num.scan}{integer, number of scans.}

\item{ntps.per.scan}{integer, number of timepoints per scan.}

\item{save_res}{logical, whether to save the result or not, if true, an output directory should be provided.}

\item{output_dir}{character, directory for output files.}

\item{ci_level}{numeric, level of confidence interval, default is 0.975.}

\item{ngrid}{integer, number of grids.}

\item{cores}{integer, number of cores to register for parallel jobs.}

\item{seed}{numeric, random seed.}
}
\value{
An object of list containing all the information of the static functional connectivity linear mixed model. It stores the information of model parameters, input data, and model results. 
\describe{
\item{params}{Store the parameters for the linear mixed model}
\item{parallel}{Store the information about parallel computing environment and parameters}
\item{output_by_row}{Store the model results information for data between each pair of regions}
\item{modelDyn_results}{A combined dataframe with all the model results informations}
\item{est_CI}{A list of matrices, contains information of confidence band estimate, see description below.}
In each matrix of \code{est_CI}:

  \item{row 1}{Base line estimate, difference between condition 1 and condition 2}
  \item{row 2}{Dynamic functional connecvity estimates for condition 1}
  \item{row 3}{Dynamic functional connecvity estimates for condition 2}
  \item{row 4}{Lower bound of 95\% confidence interval of condition-difference estimates}
  \item{row 5}{Upper bound of 95\% confidence interval of condition-difference estimates}
  \item{row 6}{Lower bound of 95\% confidence interval of condition-1 estimates}
  \item{row 7}{Upper bound of 95\% confidence interval of condition-1 estimates}
  \item{row 8}{Lower bound of 95\% confidence interval of condition-2 estimates}
  \item{row 9}{Upper bound of 95\% confidence interval of condition-2 estimates}
}
}
\description{
Linear mixed effect modeling for static functional connectivity
}
\details{
\code{lmmDyn} and \code{lmmConn}, we need to summarize the bootstrapping by taking the mean or median of the dFC estimate at each time point.
}
\examples{

# Assuming user has run MLPB_boot() and has summarized the bootstrapping results 
# by calculating the median or mean.

## Example with 5 subjects bootstrap-based static functional connectivity estimates data included
## Each subject's data has 731 time points in total, which includes 6 scans and 105 effective 
## time point for each scan. 
## 3 regions of interest (ROIs) comparision pairs are selected

data(MLPB_output_median)
subjects <- c('subject1', 'subject2', 'subject3', 'subject4', 'subject5')

# In our demo data, each subject has a scan with a total of 750 time points
time.points <- c(1:105, 126:230, 251:355,
                 376:480, 501:605, 626:730) 
                 
num.scan <- 6 # Each subject has 6 scans
ntps.per.scan <- 105 # Each scan has 105 time points

resConn <- lmmConn(MLPB_output_median, subjects, time.points, num.scan, ntps.per.scan)
\dontshow{
rm(list = c('subjects', 'MLPB_output_median', 'time.points', 'num.scan', 'ntps.per.scan','resConn'))
gc()}
}
