% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funktionen.R
\name{heteroZygotTest}
\alias{heteroZygotTest}
\title{Function to check whether a window is (loosely) heterozygous or not}
\usage{
heteroZygotTest(x, gaps, maxHom, maxMiss, maxGap, i, windowSize)
}
\arguments{
\item{x}{vector of 0/1 genotypes (from genoConvert())}

\item{gaps}{vector of differences between consecutive positions (gaps) in bps}

\item{maxHom}{max n. of homozygous SNP in a heterozygous window}

\item{maxMiss}{max n. of missing in a window}

\item{maxGap}{max distance between consecutive SNP in a window to be still considered a potential run}

\item{i}{index along the genome (genome-vector for each individual)}

\item{windowSize}{size of window (n. of SNP)}
}
\value{
a list: i) TRUE/FALSE (whether a window is heterozygous or NOT); ii) indexes of "opposite and missing" genotype
}
\description{
This is a core function within the sliding-window workflow. Parameters on how to consider a window heterozygous are here (maxHom, maxMiss)
}
