% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t-dist.R
\name{t_plot}
\alias{t_plot}
\alias{t_per}
\alias{t_prob}
\title{Visualize t Distribution}
\usage{
t_plot(df = 3)

t_per(probs = 0.95, df = 4, type = c("lower", "upper", "both"))

t_prob(perc, df, type = c("lower", "upper", "interval", "both"))
}
\arguments{
\item{df}{degrees of freedom}

\item{probs}{a probability value}

\item{type}{lower tail, upper tail, interval or both}

\item{perc}{a quantile value}
}
\value{
percentile for the \code{probs} based on \code{df} and
\code{type} or probability value for the \code{perc} based on \code{df} and
\code{type}
}
\description{
Visualize how degrees of freedom affect the shape of t
distribution. compute\/visualize quantiles out of given probability and
probability from a given quantile.
}
\examples{
# visualize t distribution
t_plot()
t_plot(6)
t_plot(df = 8)

# compute\\/visualize quantiles out of given probability
t_per(probs = 0.95, df = 4, type = 'lower')
t_per(probs = 0.35, df = 4, type = 'upper')
t_per(probs = 0.69, df = 7, type = 'both')

# compute\\/visualize probability from a given quantile
t_prob(2.045, 7, 'lower')
t_prob(0.945, 7, 'upper')
t_prob(1.445, 7, 'interval')
t_prob(1.6, 7, 'both')
}
\seealso{
\code{\link[stats]{TDist}}
}
