% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screener.R
\name{screener}
\alias{plot.screener}
\alias{screener}
\title{Screen Data Frames}
\usage{
screener(y)

\method{plot}{screener}(x, ...)
}
\arguments{
\item{y}{a data frame}

\item{x}{an object of class \code{screener}}

\item{...}{further arguments to be passed to or from methods}
}
\value{
\code{screeneer} returns an object of class \code{"screener"}.
An object of class \code{"screener"} is a list containing the
following components

\item{Rows}{number of rows in the data frame}
\item{Columns}{number of columns in the data frame}
\item{Variables}{names of the variables in the data frame}
\item{Types}{class of the variables in the data frame}
\item{Count}{length of the variables in the data frame}
\item{nlevels}{number of levels of a factor variable}
\item{levels}{levels of factor variables in the data frame}
\item{Missing}{number of missing observations in each variable}
\item{MissingPer}{Percent of missing observations in each variable}
\item{MissingTotal}{total number of missing observations in the data frame}
\item{MissingTotPer}{total percent of missing observations in the data frame}
\item{MissingRows}{total number of rows with missing observations in the
data frame}
\item{MissingCols}{total number of columns with missing observations in the
data frame}
}
\description{
screener will screen data frames and return details such
as variable names, class, levels and missing values. \code{plot.screener}
creates bar plots to visualize % of missing observations for each variable
in a data frame.
}
\examples{
# screen data
mt <- mtcars
mt[, c(2, 8:11)] <- lapply(mt[, c(2, 8:11)], factor)
mt[sample(1:nrow(mt), 12), sample(1:ncol(mt), 6)] <- NA
screener(mt)

# visualize missing data
k <- screener(mt)
plot(k)
}

