% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-summary.R
\name{group_summary}
\alias{boxplot.group_summary}
\alias{group_summary}
\title{Descriptive Statistics By Group}
\usage{
group_summary(fvar, cvar)

\method{boxplot}{group_summary}(x, ...)
}
\arguments{
\item{fvar}{a factor variable}

\item{cvar}{a continuous variable}

\item{x}{an object of the class \code{group_summary}}

\item{...}{further arguments to be passed to or from methods}
}
\value{
\code{group_summary} returns an object of class \code{"group_summary"}.
An object of class \code{"group_summary"} is a list containing the
following components:

\item{stats}{a data frame containing descriptive statistics for the different
levels of the factor variable}
\item{plotdata}{data for boxplot method}
\item{xvar}{name of the categorical variable}
\item{yvar}{name of the continuous variable}
}
\description{
\code{group_summary} returns descriptive statistics of a
continuous variable for the different levels of a categorical variable.
\code{boxplot.group_summary} creates boxplots of the continuous variable
for the different levels of the categorical variable.
}
\examples{
# group summary
mt <- mtcars
mt$cyl <- as.factor(mt$cyl)
group_summary(mt$cyl, mt$mpg)

# boxplot
k <- group_summary(mt$cyl, mt$mpg)
boxplot(k)
}
\seealso{
\code{link{summary_stats}}
}

