\name{NPMLE.Plackett}
\alias{NPMLE.Plackett}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Semiparametric Inference for copula models with dependent truncation data}
\description{Nonparametric maximum likelihood estimation for dependent truncation data under 
the Plackett copula models. The forms of the marginal distributions for X and Y are completely unspecified, but
the parametric form of copula is specified as the Plackett copula. Currently, the method cannot handle
tied data, though it is possible to modify by the method in Emura & Wang(2012).
}
\usage{
NPMLE.Plackett(x.trunc, y.trunc, x.fix = median(x.trunc), y.fix = median(y.trunc), Fx.plot = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x.trunc}{vector of truncation variables that is preceded by y.trunc}
  \item{y.trunc}{vector of variables that precede x.trunc}
  \item{x.fix}{vector of fixed points at which marginal distribution function of X is calculated}
  \item{y.fix}{vector of fixed points at which marginal survival function of Y are calculated}
  \item{Fx.plot}{if TRUE, the culumative distribution function for X is plotted}
}
\details{
The function produces the nonparametric maximum likelihood estimate (NPMLE) for the marginal distributions
 and the estimate of the association parameter under the Plackett copula model. The method follows Emura & Wang (2012).
The maximization of the likelihood (L) is conducted by minimizing -logL by "nlm". Standard errors are calculated
from the diagonal elements in the observed Fisher information matrix, which is obtained from the output of the "nlm".  
}
\value{
\item{alpha }{estimate of association parameter}
\item{alpha_se }{standard error of the estimate of association parameter}
\item{Hx }{estimate of the marginal cumulative reverse-hazard function for X}
\item{Hx_se }{standard error of the estimate of the marginal cumulative reverse-hazard function for X}
\item{Ay }{estimate of the marginal cumulative hazard function for Y}
\item{Ay_se }{standard error of the estimate of the marginal cumulative hazard function for Y}
\item{Fx }{estimate of the marginal distribution function for X}
\item{Hx_se }{standard error of the estimate of the marginal distribution function for X}
\item{Sy }{estimate of the marginal survival function for Y}
\item{Sy_se }{standard error of the estimate of the marginal survival function for Y}
\item{conv }{an integer indicating why the optimization process terminated in "nlm": If conv=1,
the maximization of the likelihood function is properly done. Please refer R function "nlm"
 for more details.}
}

\references{
Emura, T. and Wang, W. 2012, Nonparametric maximum likelihood estimation for dependent truncation data based on copula.
Journal of Multivariate Analysis, in revision.
}
\author{Takeshi EMURA}

\examples{
##### Generate truncated data from Plackett copula with unit exponential marginals #####
set.seed(1)
m=35 #### sample size ####
alpha_true=1/5.11 #### Kendall's tau on (X,Y) = 0.5 ####
x.trunc=y.trunc=numeric(m)
l=1
while(l<=m){
  u=runif(1,min=0,max=1)
  v=runif(1,min=0,max=1)
  K=function(w){
    A=sqrt( (1+(alpha_true-1)*(u+w))^2-4*alpha_true*(alpha_true-1)*u*w )  
    2*v+(  1+(alpha_true-1)*u-(alpha_true+1)*w  )/A-1
  }
  low=0.00001*u
  up=1-0.00001*v
  for(j in 1:100){ #### Invert K(.) by the bisection method to ####
    mid=(low+up)/2;M<-K(mid);U<-K(up)
    if(M*U>0){up<-mid}else{low<-mid}
  }
  w=mid
  x=-log(1-u);y=-log(w)
  if((x<y)){
  x.trunc[l]=x;y.trunc[l]=y
  l=l+1
  }
}

NPMLE.Plackett(x.trunc, y.trunc, x.fix =1, y.fix = 1, Fx.plot = TRUE)

#### compare the above estimate with the true value #####
c(alpha_true=alpha_true,Fx_true=1-exp(-1),Sy_true=exp(-1))
}

\keyword{ Copula }
\keyword{ Semiparametric method }% __ONLY ONE__ keyword per line
