% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulators.R
\name{sim}
\alias{sim}
\title{Simulator for deterministic discrete time model with memory}
\usage{
sim(
  transitions,
  initialValues,
  parameters = NULL,
  simulationDuration,
  timeStep = 1,
  errorTolerance = 0.001
)
}
\arguments{
\item{transitions}{a list of transitions follows this format \code{"transition" = distribution()}}

\item{initialValues}{a vector contains the initial values of all compartments defined
in the \strong{transitions}, follows this format \code{compartment_name = initial_value}}

\item{parameters}{a vector contains values of any parameters that are not compartments,
usually parameters used in \code{mathexp()} functions}

\item{simulationDuration}{duration of time to be simulate}

\item{timeStep}{set the output time interval. For example, if \code{simulationDuration = 10}
means 10 days and \code{timeStep = 0.1}, the output will display results for each 0.1 daily interval}

\item{errorTolerance}{set the threshold so that a cumulative distribution function
can be rounded to 1. For example, if we want a cumulative probability of 0.999 to
be rounded as 1, we set \code{errorTolerance = 0.001} (1 - 0.999 = 0.001). Default is 0.001}
}
\value{
a data.frame with class \code{denim} that can be plotted with a \code{plot()} method
}
\description{
Simulation function that call the C++ simulator
}
\examples{
transitions <- list(
   "S -> I" = "beta * S * I / N",
   "I -> R" = d_gamma(1/3, 2)
)

initialValues <- c(
   S = 999, 
   I = 1, 
   R = 0
)

parameters <- c(
   beta = 0.012,
   N = 1000
)

simulationDuration <- 30
timeStep <- 0.01

mod <- sim(transitions = transitions, 
           initialValues = initialValues, 
           parameters = parameters, 
           simulationDuration = simulationDuration, 
           timeStep = timeStep)
}
