% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse_daily_data.R
\name{glimpse_daily_data}
\alias{glimpse_daily_data}
\title{glimpse_daily_data}
\usage{
glimpse_daily_data(
  env_data,
  na.color = "red",
  low_color = "blue",
  high_color = "green",
  tidy_env_data = FALSE
)
}
\arguments{
\item{env_data}{a data frame of daily sequences of environmental data as
columns and years as row names. Each row represents a year and
each column represents a day of a year. Alternatively, env_data could be a
tidy data with three columns, i.e. Year, DOY and third column representing
values of mean temperatures, sum of precipitation etc. If tidy data is passed
to the function, set the argument tidy_env_data to TRUE.}

\item{na.color}{color to use for missing values}

\item{low_color}{colours for low end of the gradient}

\item{high_color}{colours for high end of the gradient}

\item{tidy_env_data}{if set to TRUE, env_data should be inserted as a data frame with three
columns: "Year", "DOY", "Precipitation/Temperature/etc."}
}
\description{
Visual presentation of daily data to spot missing values.
}
\examples{
library(dendroTools)
data("LJ_daily_temperatures")
glimpse_daily_data(env_data = LJ_daily_temperatures,
    tidy_env_data = FALSE, na.color = "white")

data("LJ_daily_precipitation")
glimpse_daily_data(env_data = LJ_daily_precipitation,
    tidy_env_data = TRUE, na.color = "white")
}
