% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monthly_response.R
\name{monthly_response}
\alias{monthly_response}
\title{monthly_response}
\usage{
monthly_response(response, env_data, method = "lm",
  metric = "r.squared", previous_year = FALSE, neurons = 1,
  brnn_smooth = TRUE, remove_insignificant = TRUE, alpha = 0.05,
  row_names_subset = FALSE, PCA_transformation = FALSE,
  log_preprocess = TRUE, components_selection = "automatic",
  eigenvalues_threshold = 1, N_components = 2,
  aggregate_function = "mean", temporal_stability_check = "sequential",
  k = 2, k_running_window = 30, cross_validation_type = "blocked",
  subset_years = NULL, plot_specific_window = NULL, ylimits = NULL,
  seed = NULL, tidy_env_data = FALSE)
}
\arguments{
\item{response}{a data frame with tree-ring proxy variables as columns and
(optional) years as row names. Row.names should be matched with those from a
env_data data frame. If not, set row_names_subset = TRUE.}

\item{env_data}{a data frame of monthly sequences of environmental
data as columns and years as row names. Each row represents a year and
each column represents a day of a year (or month). Row.names should be matched with
those from a response data frame. If not, set row_names_subset = TRUE.
Alternatively, env_data could be a tidy data with three columns,
i.e. Year, DOY (Month) and third column representing values of mean temperatures,
sum of precipitation etc. If tidy data is passed to the function, set the argument
tidy_env_data to TRUE.}

\item{method}{a character string specifying which method to use. Current
possibilities are "cor", "lm" and "brnn".}

\item{metric}{a character string specifying which metric to use. Current
possibilities are "r.squared" and "adj.r.squared". If method = "cor",
metric is not relevant.}

\item{previous_year}{if set to TRUE, env_data and response variables will be
rearranged in a way, that also previous year will be used for calculations of
selected statistical metric.}

\item{neurons}{positive integer that indicates the number of neurons used
for brnn method}

\item{brnn_smooth}{if set to TRUE, a smoothing algorithm is applied that
removes unrealistic calculations which are a result of neural net failure.}

\item{remove_insignificant}{if set to TRUE, removes all correlations bellow
the significant threshold level, based on a selected alpha. For "lm" and
"brnn" method, squared threshold is used, which corresponds to R squared
statistics.}

\item{alpha}{significance level used to remove insignificant calculations.}

\item{row_names_subset}{if set to TRUE, row.names are used to subset
env_data and response data frames. Only years from both data frames are
kept.}

\item{PCA_transformation}{if set to TRUE, all variables in the response
data frame will be transformed using PCA transformation.}

\item{log_preprocess}{if set to TRUE, variables will be transformed with
logarithmic transformation before used in PCA}

\item{components_selection}{character string specifying how to select the Principal
Components used as predictors.
There are three options: "automatic", "manual" and "plot_selection". If
argument is set to automatic, all scores with eigenvalues above 1 will be
selected. This threshold could be changed by changing the
eigenvalues_threshold argument. If parameter is set to "manual", user should
set the number of components with N_components argument. If components
selection is set to "plot_selection", Scree plot will be shown and a user must
manually enter the number of components to be used as predictors.}

\item{eigenvalues_threshold}{threshold for automatic selection of Principal Components}

\item{N_components}{number of Principal Components used as predictors}

\item{aggregate_function}{character string specifying how the monthly data should be
aggregated. The default is 'mean', the two other options are 'median' and 'sum'}

\item{temporal_stability_check}{character string, specifying, how temporal stability
between the optimal selection and response variable(s) will be analysed. Current
possibilities are "sequential", "progressive" and "running_window". Sequential check
will split data into k splits and calculate selected metric for each split. Progressive
check will split data into k splits, calculate metric for the first split and then
progressively add 1 split at a time and calculate selected metric. For running window,
select the length of running window with the k_running_window argument.}

\item{k}{integer, number of breaks (splits) for temporal stability and cross validation
analysis.}

\item{k_running_window}{the length of running window for temporal stability check.
Applicalbe only if temporal_stability argument is set to running window.}

\item{cross_validation_type}{character string, specifying, how to perform cross validation
between the optimal selection and response variables. If the argument is set to "blocked",
years will not be shuffled. If the argument is set to "randomized", years will be shuffled.}

\item{subset_years}{a subset of years to be analyzed. Should be given in the form of
subset_years = c(1980, 2005)}

\item{plot_specific_window}{integer representing window width to be displayed
for plot_specific}

\item{ylimits}{limit of the y axes for plot_extreme and plot_specific. It should be
given in the form of: ylimits = c(0,1)}

\item{seed}{optional seed argument for reproducible results}

\item{tidy_env_data}{if set to TRUE, env_data should be inserted as a data frame with three
columns: "Year", "Month", "Precipitation/Temperature/etc."}
}
\value{
a list with 13 elements:
\tabular{rll}{
 1 \tab $calculations   \tab a matrix with calculated metrics\cr
 2 \tab $method \tab the character string of a method \cr
 3 \tab $metric   \tab the character string indicating the metric used for calculations \cr
 4 \tab $analysed_period    \tab the character string specifying the analysed period based on the information from row names. If there are no row names, this argument is given as NA \cr
 5 \tab $optimized_return   \tab data frame with two columns, response variable and aggregated (averaged) monthly data that return the optimal results. This data.frame could be directly used to calibrate a model for climate reconstruction \cr
 6 \tab $optimized_return_all    \tab a data frame with aggregated monthly data, that returned the optimal result for the entire env_data (and not only subset of analysed years) \cr
 7 \tab $transfer_function    \tab a ggplot object: scatter plot of optimized return and a transfer line of the selected method \cr
 8 \tab $temporal_stability    \tab a data frame with calculations of selected metric for different temporal subsets\cr
 9\tab $cross_validation   \tab a data frame with cross validation results \cr
 10 \tab $plot_heatmap    \tab ggplot2 object: a heatmap of calculated metrics\cr
 11 \tab $plot_extreme    \tab ggplot2 object: line or bar plot of a row with the highest value in a matrix of calculated metrics\cr
 12 \tab $plot_specific    \tab not avaliable for monthly_response() \cr
 13 \tab $PCA_output    \tab princomp object: the result output of the PCA analysis\cr
 14 \tab $type    \tab the character string describing type of analysis: daily or monthly
}
}
\description{
Function calculates all possible values of a selected statistical metric
between one or more response variables and monthly sequences of environmental
data. Calculations are based on moving window which slides through monthly
environmental data. All calculated metrics are stored in a matrix. The
location of stored calculated metric in the matrix is indicating a window
width (row names) and a location in a matrix of monthly sequences of
environmental data (column names).
}
\examples{
\dontrun{
# Load the dendroTools R package
library(dendroTools)

# Load data used for examples
data(data_MVA)
data(data_TRW)
data(data_TRW_1)
data(example_proxies_individual)
data(example_proxies_1)
data(LJ_monthly_temperatures)
data(LJ_monthly_precipitation)

# 1 Example with tidy precipitation data
example_tidy_data <- monthly_response(response = data_MVA, env_data = LJ_monthly_precipitation,
                                     method = "cor", row_names_subset = TRUE,
                                     remove_insignificant = TRUE, previous_year = TRUE,
                                     alpha = 0.05, aggregate_function = 'sum',
                                     tidy_env_data = TRUE)
example_tidy_data$plot_extreme
example_tidy_data$plot_heatmap

# 2 Example with splited data for past and present
example_MVA_past <- monthly_response(response = data_MVA, env_data = LJ_monthly_temperatures,
                                     method = "cor", row_names_subset = TRUE, previous_year = TRUE,
                                     remove_insignificant = TRUE, alpha = 0.05,
                                     subset_years = c(1940, 1980), aggregate_function = 'mean')

example_MVA_present <- monthly_response(response = data_MVA, env_data = LJ_monthly_temperatures,
                                      method = "cor", row_names_subset = TRUE, alpha = 0.05,
                                      previous_year = TRUE, remove_insignificant = TRUE,
                                      subset_years = c(1981, 2010), aggregate_function = 'mean')

example_MVA_past$plot_heatmap
example_MVA_present$plot_heatmap
example_MVA_past$plot_extreme
example_MVA_present$plot_extreme


# 3 Example with principal component analysis
example_PCA <- monthly_response(response = example_proxies_individual,
                              env_data = LJ_monthly_temperatures, method = "lm",
                              row_names_subset = TRUE, remove_insignificant = TRUE,
                              alpha = 0.01, PCA_transformation = TRUE, previous_year = TRUE,
                              components_selection = "manual", N_components = 2)

summary(example_PCA$PCA_output)
example_PCA$plot_heatmap
example_PCA$plot_extreme

# 4 Example negative correlations
example_neg_cor <- monthly_response(response = data_TRW_1, alpha = 0.05,
                                    env_data = LJ_monthly_temperatures,
                                    method = "cor", row_names_subset = TRUE,
                                    remove_insignificant = TRUE)

example_neg_cor$plot_heatmap
example_neg_cor$plot_extreme
example_neg_cor$temporal_stability

# 5 Example of multiproxy analysis
summary(example_proxies_1)
cor(example_proxies_1)

example_multiproxy <- monthly_response(response = example_proxies_1,
                                     env_data = LJ_monthly_temperatures,
                                     method = "lm", metric = "adj.r.squared",
                                     row_names_subset = TRUE, previous_year = FALSE,
                                     remove_insignificant = TRUE, alpha = 0.05)

example_multiproxy$plot_heatmap

# 6 Example to test the temporal stability
example_MVA_ts <- monthly_response(response = data_MVA, env_data = LJ_monthly_temperatures,
method = "lm", metric = "adj.r.squared", row_names_subset = TRUE,
remove_insignificant = TRUE, alpha = 0.05,
temporal_stability_check = "running_window", k_running_window = 10)

example_MVA_ts$temporal_stability

}
}
