% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_matrix.R
\name{smooth_matrix}
\alias{smooth_matrix}
\title{smooth_matrix}
\usage{
smooth_matrix(mat, factor_drop = 0.7, repeats = 3)
}
\arguments{
\item{mat}{a matrix or data.frame}

\item{factor_drop}{a number that specifies by how many % should a value drop,
comparing to two the closest values in a row (i +1 and i -1), to be
considered as a unrealistic value.}

\item{repeats}{an integer that specifies number of repeats of smoothing.
Important when there are more unrealistic values one by another.}
}
\value{
a matrix with replaced unrealistic values
}
\description{
Removes unrealistic values in a matrix and replace them with an average of
values in a window 3 x 3 around the unrealistic value. Unrealistic value is
determined by a factor_drop.
}
\examples{
\dontrun{
library(dendroTools)
data(LJ_daily_temperatures)
data(example_proxies_1)
Example1 <- daily_response(response = example_proxies_1,
env_data = LJ_daily_temperatures, method = "brnn",
measure = "r.squared", lower = 250, upper = 251,
previous_year = FALSE, brnn_smooth = TRUE, alpha = 0.1)
smoothed <- smooth_matrix(mat = Example1[[1]])

mat_1 <-  matrix(seq(1.01, 2, by = 0.01)  , ncol = 10, byrow = TRUE)
mat_1[5 ,5] <- -1
mat_2 <- smooth_matrix(mat_1)
#' }
}
