% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr_access.R
\name{get_leaves_edgePar}
\alias{get_leaves_edgePar}
\title{Get edgePar of dendrogram's leaves}
\usage{
get_leaves_edgePar(dend, simplify = FALSE, ...)
}
\arguments{
\item{dend}{a dendrogram object}

\item{simplify}{logical (default is FALSE). If TRUE, then the return vector is
after using \code{unlist} on it.}

\item{...}{not used}
}
\value{
A list (or a vector) with the dendrogram's leaves edgePar attribute
}
\description{
This is helpful to get the attributes of branches of the leaves.
For example, after we use \link{color_branches}, to get the colors
of the labels to match (since getting the colors of branches to match
those of the labels can be tricky).
}
\examples{
# define dendrogram object to play with:
hc <- hclust(dist(USArrests[1:5, ]), "ave")
dend <- as.dendrogram(hc)

# get_leaves_edgePar(dend) # error :)
get_leaves_edgePar(dend)
dend <- color_branches(dend, k = 3)
get_leaves_edgePar(dend)
get_leaves_edgePar(dend, TRUE)

dend <- dend \%>\% set("branches_lwd", c(2, 1, 2))
get_leaves_edgePar(dend)

plot(dend)
}
\seealso{
\link{get_nodes_attr}, \link{assign_values_to_leaves_nodePar}, \link{labels_colors}
\link{get_leaves_nodePar}
}
