% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels_colors.R
\name{labels_cex}
\alias{labels_cex}
\alias{labels_cex<-}
\title{Retrieve/assign cex to the labels of a dendrogram}
\usage{
labels_cex(dend, ...)

labels_cex(dend, ...) <- value
}
\arguments{
\item{dend}{a dendrogram object}

\item{...}{not used}

\item{value}{a vector of cex to be used as new label's size for the dendrogram}
}
\value{
A vector with the dendrogram's labels sizes (NULL if none are supplied).
}
\description{
Retrieve/assign cex to the labels of a dendrogram
}
\examples{
# define dendrogram object to play with:
dend <- as.dendrogram(hclust(dist(USArrests[1:3,]), "ave"))

# Defaults:
labels_cex(dend)
plot(dend)

# let's add some color:
labels_cex(dend) <- 1:3
labels_cex(dend)
plot(dend)
   
labels_cex(dend) <- 1
labels_cex(dend)
plot(dend)

}
