% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.R
\name{intersect_trees}
\alias{intersect_trees}
\title{Intersect trees}
\usage{
intersect_trees(dend1, dend2, warn = dendextend_options("warn"), ...)
}
\arguments{
\item{dend1}{tree object (dendrogram/hclust/phylo)}

\item{dend2}{tree object (dendrogram/hclust/phylo)}

\item{warn}{logical (default from dendextend_options("warn") is FALSE).
Set if warning are to be issued, it is safer to keep this at TRUE,
but for keeping the noise down, the default is FALSE.
Should a warning be issued if there was a need to perform intersaction.}

\item{...}{passed on}
}
\value{
A \link{dendlist} with two pruned trees
}
\description{
Return two trees after pruning them so that the only leaves left are the intersection of their labels.
}
\examples{
hc <- hclust(dist(USArrests[1:5,]), "ave")
dend <- as.dendrogram(hc)
labels(dend) <- 1:5
dend1 <- prune(dend, 1)
dend2 <- prune(dend, 5)
intersect_dend <- intersect_trees(dend1, dend2)

layout(matrix(c(1,1,2,3,4,5), 3,2, byrow=TRUE))
plot(dend, main = "Original tree")
plot(dend1, main = "Tree 1:\\n original with label 1 pruned");
   plot(dend2, main = "Tree 2:\\n original with label 2 pruned")
plot(intersect_dend[[1]], 
      main = "Tree 1 pruned
      with the labels that intersected with those of Tree 2")
   plot(intersect_dend[[2]],
      main = "Tree 2 pruned
      with the labels that intersected with those of Tree 1")

}
\seealso{
\link{prune}, \link{intersect}, \link{labels}
}

