% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unbranch.R
\name{get_root_branches_attr}
\alias{get_root_branches_attr}
\title{get attributes from the dendrogram's root(!) branches}
\usage{
get_root_branches_attr(dend, the_attr, warn = dendextend_options("warn"), ...)
}
\arguments{
\item{dend}{dendrogram object}

\item{the_attr}{the attribute to get from the branches (for example "height")}

\item{warn}{logical (default from dendextend_options("warn") is FALSE).
Set if warning are to be issued, it is safer to keep this at TRUE,
but for keeping the noise down, the default is FALSE.
Should a warning be printed when 
the function is used on an object which is NOT a dendrogram.}

\item{...}{passed on to attr}
}
\value{
The attributes of the branches (often two) of the dendrogram's root
}
\description{
get attributes from the dendrogram's root(!) branches
}
\examples{
hc <- hclust(dist(USArrests[2:9,]), "com")
dend <- as.dendrogram(hc)

get_root_branches_attr(dend, "height") # 0.00000 71.96247
# plot(dend)
str(dend, 2)
}
\seealso{
\link{attr}
}

