\name{nnodes}
\alias{nnodes}
\alias{nnodes.default}
\alias{nnodes.dendrogram}
\alias{nnodes.hclust}
\alias{nnodes.phylo}
\title{Counts the number of nodes (Vertices) in a tree}
\usage{
nnodes(x, ...)

\method{nnodes}{dendrogram}(x, ...)

\method{nnodes}{hclust}(x, ...)

\method{nnodes}{phylo}(x, ...)
}
\arguments{
  \item{x}{tree object (dendrogram or hclust)}

  \item{...}{not used}
}
\value{
The number of leaves in the tree
}
\description{
Counts the number of nodes in a tree (dendrogram, hclust,
phylo).
}
\details{
The idea for the name is from functions like ncol, and
nrow.

The phylo method is based on turning the phylo to hclust
and than to dendrogram. It may not work for complex phylo
trees.
}
\examples{
hc <- hclust(dist(USArrests[1:5,]), "ave")
dend <- as.dendrogram(hc)

nnodes(dend) # 9
nnodes(hc) # 9
}
\seealso{
\link{nrow}, \link{count_terminal_nodes}, \link{nleaves}
}

