% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.R
\name{est_ptr_on}
\alias{est_ptr_on}
\title{Tries up to max_attempts times to compare each permutation of removing random
subsets of contigs/samples from X, and returns the PTR estimate if a valid
one comes back from the comparisons}
\usage{
est_ptr_on(X, subset_on, max_attempts = 10, num_subsets = 3, cor_cutoff = 0.98)
}
\arguments{
\item{X}{cov3 dataframe}

\item{subset_on}{either "contig" or "sample"}

\item{max_attempts}{max number of attempts to find a valid ptr estimate}

\item{num_subsets}{number of subsets to split contigs/samples into}

\item{cor_cutoff}{minimum correlation coefficient to accept PTR estimate}
}
\value{
est_ptrs dataframe on success, null otherwise
\itemize{
\item est_ptr: estimated PTR values
\item coefficient: coefficient of linear regression
\item pValue: p-value of linear regression
\item cor: correlation coefficient
\item correctY: corrected coverage
}
}
\description{
Requires a minimum of 2 * num_subsets contigs/samples
}
\examples{
est_ptrs_001_on_contigs <- est_ptr_on(max_bin_003, "contig", num_subsets = 5)
est_ptrs_001_on_contigs

est_ptrs_001_on_samples <- est_ptr_on(max_bin_003, "sample")
is.null(est_ptrs_001_on_samples)

}
