/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.AbstractGraph;

public class Subgraph<V, E, G extends Graph<V, E>>
extends AbstractGraph<V, E>
implements Serializable {
    private static final long serialVersionUID = 3208313055169665387L;
    private static final String NO_SUCH_EDGE_IN_BASE = "no such edge in base graph";
    private static final String NO_SUCH_VERTEX_IN_BASE = "no such vertex in base graph";
    protected final Set<E> edgeSet = new LinkedHashSet();
    protected final Set<V> vertexSet = new LinkedHashSet<V>();
    protected final G base;
    protected final boolean isInduced;
    private transient Set<E> unmodifiableEdgeSet = null;
    private transient Set<V> unmodifiableVertexSet = null;

    public Subgraph(G base, Set<? extends V> vertexSubset, Set<? extends E> edgeSubset) {
        this.base = (Graph)Objects.requireNonNull(base, "Invalid graph provided");
        boolean bl = this.isInduced = edgeSubset == null;
        if (base instanceof ListenableGraph) {
            ((ListenableGraph)base).addGraphListener(new BaseGraphListener());
        }
        this.initialize(vertexSubset, edgeSubset);
    }

    public Subgraph(G base, Set<? extends V> vertexSubset) {
        this(base, vertexSubset, null);
    }

    public Subgraph(G base) {
        this(base, null, null);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        if (this.containsVertex(sourceVertex) && this.containsVertex(targetVertex)) {
            return this.base.getAllEdges(sourceVertex, targetVertex).stream().filter(e -> this.edgeSet.contains(e)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        }
        return null;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        Set<E> edges = this.getAllEdges(sourceVertex, targetVertex);
        if (edges == null) {
            return null;
        }
        return edges.stream().findAny().orElse(null);
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.base.getEdgeFactory();
    }

    @Override
    public E addEdge(V sourceVertex, V targetVertex) {
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        if (!this.base.containsEdge(sourceVertex, targetVertex)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        Set edges = this.base.getAllEdges(sourceVertex, targetVertex);
        for (Object e : edges) {
            if (this.containsEdge(e)) continue;
            this.edgeSet.add(e);
            return e;
        }
        return null;
    }

    @Override
    public boolean addEdge(V sourceVertex, V targetVertex, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsEdge(e)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        this.assertVertexExist(sourceVertex);
        this.assertVertexExist(targetVertex);
        assert (this.base.getEdgeSource(e) == sourceVertex);
        assert (this.base.getEdgeTarget(e) == targetVertex);
        return this.edgeSet.add(e);
    }

    @Override
    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsVertex(v)) {
            throw new IllegalArgumentException(NO_SUCH_VERTEX_IN_BASE);
        }
        return this.vertexSet.add(v);
    }

    @Override
    public boolean containsEdge(E e) {
        return this.edgeSet.contains(e);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.vertexSet.contains(v);
    }

    @Override
    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeSet);
        }
        return this.unmodifiableEdgeSet;
    }

    @Override
    public Set<E> edgesOf(V vertex) {
        this.assertVertexExist(vertex);
        return this.base.edgesOf(vertex).stream().filter(e -> this.edgeSet.contains(e)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    @Override
    public boolean removeEdge(E e) {
        return this.edgeSet.remove(e);
    }

    @Override
    public E removeEdge(V sourceVertex, V targetVertex) {
        E e = this.getEdge(sourceVertex, targetVertex);
        return (E)(this.edgeSet.remove(e) ? e : null);
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v) && this.base.containsVertex(v)) {
            this.removeAllEdges(this.edgesOf(v));
        }
        return this.vertexSet.remove(v);
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.vertexSet);
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public V getEdgeSource(E e) {
        return this.base.getEdgeSource(e);
    }

    @Override
    public V getEdgeTarget(E e) {
        return this.base.getEdgeTarget(e);
    }

    public G getBase() {
        return this.base;
    }

    @Override
    public double getEdgeWeight(E e) {
        return this.base.getEdgeWeight(e);
    }

    public void setEdgeWeight(E e, double weight) {
        ((WeightedGraph)this.base).setEdgeWeight(e, weight);
    }

    private void initialize(Set<? extends V> vertexFilter, Set<? extends E> edgeFilter) {
        if (vertexFilter == null && edgeFilter == null) {
            this.vertexSet.addAll(this.base.vertexSet());
            this.edgeSet.addAll(this.base.edgeSet());
            return;
        }
        if (vertexFilter == null) {
            this.vertexSet.addAll(this.base.vertexSet());
        } else if (vertexFilter.size() > this.base.vertexSet().size()) {
            this.base.vertexSet().stream().filter(v -> vertexFilter.contains(v)).forEach(v -> this.vertexSet.add(v));
        } else {
            vertexFilter.stream().filter(v -> v != null && this.base.containsVertex((Object)v)).forEach(v -> this.vertexSet.add(v));
        }
        if (edgeFilter == null) {
            this.base.edgeSet().stream().filter(e -> this.vertexSet.contains(this.base.getEdgeSource((Object)e)) && this.vertexSet.contains(this.base.getEdgeTarget((Object)e))).forEach(e -> this.edgeSet.add(e));
        } else if (edgeFilter.size() > this.base.edgeSet().size()) {
            this.base.edgeSet().stream().filter(e -> edgeFilter.contains(e) && this.vertexSet.contains(this.base.getEdgeSource((Object)e)) && this.vertexSet.contains(this.base.getEdgeTarget((Object)e))).forEach(e -> this.edgeSet.add(e));
        } else {
            edgeFilter.stream().filter(e -> e != null && this.base.containsEdge((Object)e) && this.vertexSet.contains(this.base.getEdgeSource((Object)e)) && this.vertexSet.contains(this.base.getEdgeTarget((Object)e))).forEach(e -> this.edgeSet.add(e));
        }
    }

    private class BaseGraphListener
    implements GraphListener<V, E>,
    Serializable {
        private static final long serialVersionUID = 4343535244243546391L;

        private BaseGraphListener() {
        }

        @Override
        public void edgeAdded(GraphEdgeChangeEvent<V, E> e) {
            if (Subgraph.this.isInduced) {
                Object edge = e.getEdge();
                Object source = e.getEdgeSource();
                Object target = e.getEdgeTarget();
                if (Subgraph.this.containsVertex(source) && Subgraph.this.containsVertex(target)) {
                    Subgraph.this.addEdge(source, target, edge);
                }
            }
        }

        @Override
        public void edgeRemoved(GraphEdgeChangeEvent<V, E> e) {
            Object edge = e.getEdge();
            Subgraph.this.removeEdge(edge);
        }

        @Override
        public void vertexAdded(GraphVertexChangeEvent<V> e) {
        }

        @Override
        public void vertexRemoved(GraphVertexChangeEvent<V> e) {
            Object vertex = e.getVertex();
            Subgraph.this.removeVertex(vertex);
        }
    }
}

