/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.HashSet;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class CompleteBipartiteGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int sizeA;
    private int sizeB;

    public CompleteBipartiteGraphGenerator(int partitionOne, int partitionTwo) {
        if (partitionOne < 0 || partitionTwo < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.sizeA = partitionOne;
        this.sizeB = partitionTwo;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        V newVertex;
        int i;
        if (this.sizeA < 1 && this.sizeB < 1) {
            return;
        }
        HashSet<V> a = new HashSet<V>();
        HashSet<V> b = new HashSet<V>();
        for (i = 0; i < this.sizeA; ++i) {
            newVertex = vertexFactory.createVertex();
            target.addVertex(newVertex);
            a.add(newVertex);
        }
        for (i = 0; i < this.sizeB; ++i) {
            newVertex = vertexFactory.createVertex();
            target.addVertex(newVertex);
            b.add(newVertex);
        }
        for (Object u : a) {
            for (Object v : b) {
                target.addEdge(u, v);
            }
        }
    }
}

