% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{deform}
\alias{deform}
\title{Fitting low-rank nonstationary spatial Gaussian process models through spatial deformation}
\usage{
deform(
  x,
  z,
  n,
  k = c(10, 10),
  lambda = c(-1, -1),
  lambda0 = rep(exp(3), length(k)),
  correlation = FALSE,
  cosine = FALSE,
  bijective = FALSE,
  bijective.args = NULL,
  trace = 0,
  standardise = "together"
)
}
\arguments{
\item{x}{a 2-column matrix comprising x and y coordinates column-wise, respectively, or a list; see Details for the latter}

\item{z}{a variance-covariance matrix}

\item{n}{an integer number of data}

\item{k}{an integer vector of ranks}

\item{lambda}{specified lambda values; see Details}

\item{lambda0}{initial lambda values}

\item{correlation}{a logical defining whether \code{z} should be assumed to be a correlation matrix; defaults to \code{FALSE}}

\item{cosine}{a logical defining whether the powered exponential covariance function should be multiplied by the cosine of scaled distances, i.e. giving a damped oscillation; defaults to \code{FALSE}}

\item{bijective}{a logical for whether a bijective deformation should be imposed; defaults to FALSE}

\item{bijective.args}{a list specifying quantities to ensure bijectivity, if bijective == TRUE; see Details}

\item{trace}{an integer specifying the amount to report on optimisation (0, default, is nothing; 1 gives a bit)}

\item{standardise}{a character string that governs whether dimensions are scaled by a common (\code{"together"}) or dimension-specific factor; defaults to \code{"together"}}
}
\value{
An object of class \code{deform}  and then of class \code{deformation}
}
\description{
Function \code{deform} fits a 2-dimensional deformation model, where typically
x and y coordinates in geographic (G-) space will be provided and then deformed
to give new coordinates in deformed (D-) space in which isotropy of a Gaussian 
process is optimally achieved.
}
\details{
If \code{x} is a list, then it wants elements \code{"x"}, \code{"z"} and \code{"n"} as described above.

Values of \code{lambda} multiply the penalties placed on the wiggliness of the 
smooths that form the deformations. Larger values make things less wiggly. Values 
of \code{lambda0} specify initial values for \code{lambda}, which are still optimised.

\code{bijective.args()} is a 4-element list: \code{"mult"} is a penalty placed on
the numerical approximation to identifying non-bijectivity, where larger values
impose bijectivity more strictly; \code{"scl"} is a scaling placed on the grid
used to numerically identify non-bijectivity, where smaller values will typically 
impose bijectivity more strictly; \code{"nx"} and \code{"ny"} specify the x and y
dimensions of the grid used to numerically identify bijectivity. Defaults are 
\code{mult = 1e3}, \code{scl = 1}, \code{nx = 40} and \code{ny = 40}. It is advisable
to use \code{"mult"} and not \code{"scl"} to control bijectivity, in the first instance.
}
\examples{

\donttest{

data(solar)
deform(solar$x, solar$z, solar$n) 
# equivalent to deform(solar)

# bijective deformation 
deform(solar, bijective = TRUE)

# deformation with specified rank
deform(solar, k = c(10, 8))

}

}
\references{
Sampson, P. D. and Guttorp, P. (1992) Nonparametric Estimation of Nonstationary Spatial
Covariance Structure, Journal of the American Statistical Association, 87:417, 108-119,
\doi{10.1080/01621459.1992.10475181}

Wood, S.N. (2003), Thin plate regression splines. Journal of the Royal Statistical 
Society: Series B (Statistical Methodology), 65: 95-114. 
\doi{10.1111/1467-9868.00374}
}
