% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disparity_through_time.R
\name{disparity_through_time}
\alias{disparity_through_time}
\title{Disparity through time plot using lattice}
\usage{
disparity_through_time(
  x,
  data,
  groups,
  pch = 16,
  col.point = c("blue"),
  scales = list(arrows = FALSE, distance = 1, col = "black", z = list(rot = 90)),
  colorkey = FALSE,
  screen = list(z = 90, x = 70, y = 180),
  aspect = c(1.5, 4),
  drape = TRUE,
  col.regions = c("white"),
  alpha.regions = c(1),
  perspective = FALSE,
  R.mat = matrix(c(1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1), 4, 4),
  par.settings = list(axis.line = list(col = "transparent"), layout.heights =
    list(top.padding = 0, main.key.padding = 0, key.axis.padding = 0, axis.xlab.padding =
    0, xlab.key.padding = 0, key.sub.padding = 0, bottom.padding = 0), layout.widths =
    list(left.padding = 0, key.ylab.padding = 0, ylab.axis.padding = 0, axis.key.padding
    = 0, right.padding = 0)),
  lattice.options = list(axis.padding = list(factor = 0)),
  ...
)
}
\arguments{
\item{x}{a formula (most likely of the form \code{z ~ x * y})}

\item{data}{a data frame in which variables in the formula are to be evaluated}

\item{groups}{a variable in \code{data} to be used as a grouping variable (this is probably the z variable)}

\item{pch}{the point type}

\item{col.point}{color(s) for points on surfaces}

\item{scales}{a list specifying how the axes are drawn (see \code{\link[lattice]{xyplot}} for details)}

\item{colorkey}{logical, should a legend be drawn (or a list describing the legend; see \code{\link[lattice]{levelplot}} for details)}

\item{screen}{a list of the rotations that should be applied to each axis}

\item{aspect}{a numeric vector of length 2, giving the relative aspects of the y-size/x-size and z-size/x-size of the enclosing cube}

\item{drape}{logical, whether the surfaces should be colored based on \code{col.regions} and \code{alpha.regions}}

\item{col.regions}{color(s) for surfaces}

\item{alpha.regions}{alpha value(s) for surfaces}

\item{perspective}{logical, whether to plot a perspective view}

\item{R.mat}{a transformational matrix that is applied to the orientation of the axes}

\item{par.settings}{plotting settings (see \code{\link[lattice]{trellis.par.set}})}

\item{lattice.options}{lattice settings (see \code{\link[lattice]{lattice.options}})}

\item{...}{Other arguments passed to \code{\link[lattice]{wireframe}}}
}
\value{
An object of class \code{"trellis"}, as output by \code{\link[lattice]{wireframe}}.
}
\description{
Plots points on 2-D surfaces within a a 3-D framework. See \code{\link[lattice]{wireframe}} and \code{\link[lattice]{panel.cloud}} for customization options.
}
\examples{
g <- data.frame(x = runif(100, 0, 60), y = runif(100,0,10),
                z = factor(rep(periods$name[1:5], each=20),
                levels = periods$name[1:5]))
disparity_through_time(z~x*y, data = g, groups = z, aspect = c(1.5,2),
                       xlim = c(0,60), ylim = c(0,10), col.regions = "lightgreen",
                       col.point = c("red","blue"))
}
