% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_texts.R
\name{split_text}
\alias{split_text}
\title{Split texts into segments}
\usage{
split_text(text, max_size_bytes = 29000, tokenize = "sentences")
}
\arguments{
\item{text}{character vector to be split.}

\item{max_size_bytes}{maximum size of a single text segment in bytes.}

\item{tokenize}{level of tokenization. Either "sentences" or "words".}
}
\value{
Returns a (\code{tibble}) with the following columns:
\itemize{
\item \code{text_id} position of the text in the character vector.
\item \code{segment_id} ID of a text segment.
\item \code{segment_text} text segment that is smaller than \code{max_size_bytes}
}
}
\description{
\code{split_text} splits texts into blocks of a maximum number of bytes.
}
\details{
The function uses \code{tokenizers::tokenize_sentences} to split texts.
}
\examples{
\dontrun{
# Split long text
text <- paste0(rep("This is a very long text.", 10000), collapse = " ")
split_text(text)
}

}
