% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvnorm_eclairs.R
\name{rmvnorm_eclairs}
\alias{rmvnorm_eclairs}
\title{Draw from multivariate normal and t distributions}
\usage{
rmvnorm_eclairs(n, mu, ecl, v = Inf, seed = NULL)
}
\arguments{
\item{n}{sample size}

\item{mu}{mean vector}

\item{ecl}{covariance matrix as an \link{eclairs} object}

\item{v}{degrees of freedom, defaults to Inf.  If finite, uses a multivariate t distribution}

\item{seed}{If you want the same to be generated again use a seed for the generator, an integer number}
}
\value{
matrix where rows are samples from multivariate normal or t distribution where columns have covariance specified by \code{ecl}
}
\description{
Draw from multivariate normal and t distributions using eclairs decomposition
}
\details{
Draw from multivariate normal and t distributions using eclairs decomposition.  If the (implied) covariance matrix is \eqn{p \times p}, the standard approach is \eqn{O(p^3)}. Taking advantage of the previously computed eclairs decomposition of rank \eqn{k}, this can be done in \eqn{O(pk^2)}.
}
\examples{
library(Rfast)

n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma, seed = 1)

# perform eclairs decomposition
ecl <- eclairs(Y)

# draw from multivariate normal
n <- 10000
mu <- rep(0, ncol(Y))

# using eclairs decomposition
X.draw1 <- rmvnorm_eclairs(n, mu, ecl)

# using full covariance matrix implied by eclairs model
X.draw2 <- rmvnorm(n, mu, getCov(ecl))

# assess difference betweeen covariances from two methods
range(cov(X.draw1) - cov(X.draw2))

# compare covariance to the covariance matrix used to simulated the data
range(cov(X.draw1) - getCov(ecl))

}
