% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_point-cloud-layer.R
\name{add_point_cloud_layer}
\alias{add_point_cloud_layer}
\title{Add a point cloud layer to the deckgl widget}
\usage{
add_point_cloud_layer(deckgl, id = "point-cloud-layer", data = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{deckgl widget}

\item{id}{id of the layer}

\item{data}{url to fetch data from or data object}

\item{properties}{named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class, additionally there is a \code{getTooltip} property (callback)
showing a tooltip when the mouse enters an object,
e. g. \code{getTooltip = JS("object => object.name")}}

\item{...}{more properties (will be added to the properties object), useful if you
want to use a properties object for more than one layer}
}
\description{
The \code{PointCloudLayer} takes in points with 3d positions, normals and colors and renders them as spheres with a certain radius.
}
\examples{
## @knitr point-cloud-layer
sample_data <- paste0(
  "https://raw.githubusercontent.com/",
  "uber-common/deck.gl-data/",
  "master/website/pointcloud.json"
)

properties <- list(
  pickable = TRUE,
  coordinateSystem = JS("COORDINATE_SYSTEM.METER_OFFSETS"),
  coordinateOrigin = c(-122.4, 37.74),
  radiusPixels = 4,
  getPosition = get_property("position"),
  getNormal = get_property("normal"),
  getColor = get_property("color"),
  lightSettings = list(),
  getTooltip = JS("object => object.position.join(', ')")
)

deck <- deckgl(pitch = 45, zoom = 10.5) \%>\%
  add_point_cloud_layer(data = sample_data, properties = properties) \%>\%
  add_mapbox_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/point-cloud-layer}
}
