% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discount.R
\name{discount}
\alias{discount}
\title{Discount time series for Net Present Value (NPV) calculation}
\usage{
discount(x, discount_rate, calculate_NPV = FALSE)
}
\arguments{
\item{x}{numeric vector, typically containing time series data of costs or
benefits}

\item{discount_rate}{numeric; the discount rate (in percent), expressing the
time preference of whoever is evaluating these data economically}

\item{calculate_NPV}{boolean; if set to TRUE, the discounted time values are
summed, otherwise, they are returned as a vector}
}
\value{
If calculate_NPV=TRUE, the function returns the Net Present Value
(NPV) as a numeric value. If calculate_NPV=FALSE, the time-discounted values
are returned as a numeric vector.
}
\description{
This function discounts values along a time series, applying the specified
discount rate. It can also calculate the Net Present Value (NPV), which is
the sum of these discounted values.
}
\examples{

x<-c(3,6,2,5,4,3,9,0,110)
discount_rate<-5

discount(x,discount_rate)
discount(x,discount_rate,calculate_NPV=TRUE)


}
\author{
Eike Luedeling
}
\keyword{~kwd1}
\keyword{~kwd2}

