% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.r
\name{denoise_list}
\alias{denoise_list}
\title{List-to-list denoising of COI barcode sequences.}
\usage{
denoise_list(x, to_return = "seq", cores = 1, ...)
}
\arguments{
\item{x}{A list like object of barcode sequences.}

\item{to_return}{Indicate whether a the function should return a list of 
sequence ('seq') or the full DNAseq object ('DNAseq). Default is ('seq')}

\item{cores}{The number of cores across which to thread the denosiing. Default is 1.}

\item{...}{additional arguments to pass to the denoise algorithm.}
}
\description{
This function provides a shortcut for running the denoise function
on a list of sequences. The to_return option can be used to control
whether this function returns a list of sequence strings (default), 
or a list of DNA seq objects.
}
\examples{
#denoise a list of sequences
out = denoise_list(ex_nt_list, dir_check = FALSE, double_pass = FALSE)
#denoise and add placehers to outputs 

#return a list of DNAseq objects 
ex_DNAseq_out = denoise_list(ex_nt_list, to_return = 'DNAseq',
 dir_check = FALSE, double_pass = FALSE)

}
\seealso{
\code{\link{denoise}}
}
