% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sets.R
\docType{data}
\name{Hotels}
\alias{Hotels}
\title{Data: Wu, Tsai and Zhou (2011).}
\format{
Data frame with 23 rows and 8 columns. Definition of inputs (X) and outputs (Y):
\describe{
  \item{x1 = Employees}{Total number of employees)}
  \item{x2 = Guest_rooms}{Total number of guest rooms)}
  \item{x3 = Area_F&B}{Total area of F&B departments (in 36 square-feet)}
  \item{x4 = Operating_cost}{Total operating cost (in NT$)}
  \item{y1 = Room_revenue}{Room revenues (in NT$)}
  \item{y2 = F&B_revenue}{F&B revenues (in NT$)}
  \item{y3 = Other_revenue}{Other revenues (in NT$)}
}
}
\source{
Wu, J.; Tsai, H. and Zhou, Z. (2011). "Improving efficiency in International
tourist hotels in Taipei using a non-radial DEA mode", Internationl Journal of
Contemporary Hospitality Management, 23(1), 66-83. \doi{10.1108/09596111111101670}
}
\usage{
data("Hotels")
}
\description{
This dataset consists of 23 four- and five-plum ITHs in Taipei in 2006. Authors
consider 4 inputs and 3 outputs.
}
\examples{
# Example. Replication of results in Wu,Tsai and Zhou (2011)
data("Hotels")
data_hotels <- make_deadata(Hotels,
                            dmus = 1,
                            inputs = 2:5,
                            outputs = 6:8)
result <- model_nonradial(data_hotels,
                          orientation = "oo",
                          rts = "vrs")
efficiencies(result)

}
\seealso{
\code{\link{make_deadata}}, \code{\link{model_nonradial}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolos} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benitez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
\keyword{datasets}
